/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;

public class ReferencingResources
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<EIInstanceMinimal> referencedByList = new ArrayList<EIInstanceMinimal>();
    private Map<EIEntity, List<EIInstanceMinimal>> materializedInverseProperties = new HashMap<EIEntity, List<EIInstanceMinimal>>();

    public List<EIInstanceMinimal> getReferencedByList() {
        return this.referencedByList;
    }

    public void setReferencedByList(List<EIInstanceMinimal> allReferencingResources) {
        this.referencedByList = allReferencingResources;
    }

    public Map<EIEntity, List<EIInstanceMinimal>> getMaterializedInverseProperties() {
        return this.materializedInverseProperties;
    }

    public void addMaterializedInverseProperty(EIEntity property, EIInstanceMinimal value) {
        List<EIInstanceMinimal> pValues = this.materializedInverseProperties.get(property);
        if (pValues == null) {
            pValues = new ArrayList<EIInstanceMinimal>();
            pValues.add(value);
            this.materializedInverseProperties.put(property, pValues);
        } else {
            boolean uriInList = false;
            for (EIInstanceMinimal ei : pValues) {
                if (!ei.getInstanceURI().equals(value.getInstanceURI())) continue;
                uriInList = true;
                break;
            }
            if (!uriInList) {
                pValues.add(value);
            }
        }
    }

    public List<EIInstanceMinimal> getMaterializedInverseProperty(EIEntity property) {
        return this.materializedInverseProperties.get(property);
    }

    public void replaceMaterializedInverseProperty(EIEntity property, List<EIInstanceMinimal> values) {
        this.materializedInverseProperties.put(property, values);
    }
}

