package org.eaglei.model.gwt.server;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.eaglei.model.gwt.rpc.ModelService;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class ModelServlet extends RemoteServiceServlet implements ModelService {
    
    protected static final Log logger = LogFactory.getLog(ModelServlet.class);
    
    private EIOntModel eagleiOntModel;
    
    @Override
    public void init() {
        ApplicationContext springAppContext = 
                WebApplicationContextUtils.getWebApplicationContext(getServletContext());
        doDependencyInjection(springAppContext);
    }
    
    /*
     * Allow test subclasses to override servlet init and invoke this
     * with their own ApplicationContext.
     */
    void doDependencyInjection(ApplicationContext springAppContext) {
        this.eagleiOntModel = springAppContext.getBean(EIOntModel.class);
    }
    
    @Override
    public String getVersion() throws LoggedException {
        try {
            return eagleiOntModel.getVersion();
        } catch (Throwable t) {
            logger.error("Error in getVersion: ", t);
            throw new LoggedException();
        }
    }

    public List<EIEntity> getInstitutions() throws LoggedException {
        try {
            return eagleiOntModel.getInstitutions();
        } catch (Throwable t) {
            logger.error("Error in getTopLevelClasses: ", t);
            throw new LoggedException();
        }
    }
    
    public List<EIClass> getTopLevelClasses() throws LoggedException {
        try {
            return eagleiOntModel.getTopLevelClasses();
        } catch (Throwable t) {
            logger.error("Error in getTopLevelClasses: ", t);
            throw new LoggedException();
        }
    }
    
    public List<EIClass> getNonResourceBaseClasses() throws LoggedException {
        try {
            return eagleiOntModel.getNonResourceBaseClasses();
        } catch (Throwable t) {
            logger.error("Error in getNonResourceClasses: ", t);
            throw new LoggedException();
        }
    }
    
    public EIClass getClass(EIURI classId) throws LoggedException {
        try {
            return eagleiOntModel.getClass(classId);
        } catch (Throwable t) {
            logger.error("Error in getClass: " + classId, t);
            throw new LoggedException();
        }
    }
    
    public List<EIClass> getSuperClasses(EIURI classId) throws LoggedException {
        try {
            return eagleiOntModel.getSuperClasses(classId);
        } catch (Throwable t) {
            logger.error("Error in getSuperClasses: " + classId, t);
            throw new LoggedException();
        }
    }
    
    public List<EIClass> getSubClasses(EIURI classId) throws LoggedException {
        try {
            return eagleiOntModel.getSubClasses(classId);
        } catch (Throwable t) {
            logger.error("Error in getSubClasses: " + classId, t);
            throw new LoggedException();
        }
    }
    
    public List<EIProperty> getProperties(EIURI classId) throws LoggedException {
        try {
            List<EIProperty> listProperties = eagleiOntModel.getProperties(classId);
            return listProperties;
            /*
            // Make a copy, checking for null object property ranges.
            ArrayList<EIProperty> copy = new ArrayList<EIProperty>(listProperties.size());
            for (EIProperty p : listProperties) {
                if (p instanceof EIObjectProperty) {
                    if (((EIObjectProperty) p).getRange() == null) {
                        logger.warn("Class has Object Property with null range:  class: "+classId + " property: " + p.getEntity());
                        continue;
                    }
                 }
                copy.add(p);
            }
            return copy;
            */
        } catch (Throwable t) {
            logger.error("Error in getProperties: " + classId, t);
            throw new LoggedException();
        }
    }
    
    public List<EIEquivalentClass> getEquivalentClasses(EIURI classId) throws LoggedException {
        try {
            List<EIEquivalentClass> listEIEquivalentClasses = eagleiOntModel.getEquivalentClasses(classId);
            return listEIEquivalentClasses;
            /*
            // Make a copy, checking for null object property ranges.
            ArrayList<EIProperty> copy = new ArrayList<EIProperty>(listProperties.size());
            for (EIProperty p : listProperties) {
                if (p instanceof EIObjectProperty) {
                    if (((EIObjectProperty) p).getRange() == null) {
                        logger.warn("Class has Object Property with null range:  class: "+classId + " property: " + p.getEntity());
                        continue;
                    }
                 }
                copy.add(p);
            }
            return copy;
            */
        } catch (Throwable t) {
            logger.error("Error in getEquivalentClasses: " + classId, t);
            throw new LoggedException();
        }
    }
    
    public List<String> getClassDefinitions(List<EIURI> classURIs) throws LoggedException {
        try {
            return eagleiOntModel.getClassDefinitions(classURIs);
        } catch (Throwable t) {
            logger.error("Error in getClassDefinitions: ", t);
            throw new LoggedException();
        }
    }
    
    public List<String> getLabels(EIURI uri) throws LoggedException {
        try {
            return eagleiOntModel.getLabels(uri);
        } catch (Throwable t) {
            logger.error("Error in getLabels: ", t);
            throw new LoggedException();
        }
    }

}
