/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.gwt.rpc;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.EIValueRestriction;
import org.eaglei.model.gwt.rpc.ModelService;
import org.eaglei.model.gwt.rpc.ModelServiceAsync;

public class ClientModelManager {
    public static final ClientModelManager INSTANCE = new ClientModelManager();
    private static final ModelServiceAsync modelService = (ModelServiceAsync)GWT.create(ModelService.class);
    private List<EIEntity> listInstitutions = null;
    private List<EIClass> listTopLevelClasses = null;
    private List<EIClass> listNonResourceClasses = null;
    private final HashMap<EIURI, EIClass> mapIdToClass = new HashMap();

    private ClientModelManager() {
    }

    public void getVersion(final VersionCallback callback) {
        modelService.getVersion(new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(String result) {
                callback.onSuccess(result);
            }
        });
    }

    public void getTopLevelClasses(final TopLevelClassesCallback callback) {
        if (this.listTopLevelClasses != null) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess(ClientModelManager.this.listTopLevelClasses);
                }
            });
        } else {
            modelService.getTopLevelClasses(new AsyncCallback<List<EIClass>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<EIClass> result) {
                    ArrayList<EIClass> cacheResults = new ArrayList<EIClass>(result.size());
                    for (EIClass c : result) {
                        cacheResults.add(ClientModelManager.this.getCachedClass(c));
                    }
                    ClientModelManager.this.listTopLevelClasses = cacheResults;
                    callback.onSuccess(ClientModelManager.this.listTopLevelClasses);
                }
            });
        }
    }

    public void getNonResourceClasses(final NonResourceBaseClassesCallback callback) {
        if (this.listNonResourceClasses != null) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess(ClientModelManager.this.listNonResourceClasses);
                }
            });
        } else {
            modelService.getNonResourceBaseClasses(new AsyncCallback<List<EIClass>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<EIClass> result) {
                    ArrayList<EIClass> cacheResults = new ArrayList<EIClass>(result.size());
                    for (EIClass c : result) {
                        cacheResults.add(ClientModelManager.this.getCachedClass(c));
                    }
                    ClientModelManager.this.listNonResourceClasses = cacheResults;
                    callback.onSuccess(ClientModelManager.this.listNonResourceClasses);
                }
            });
        }
    }

    public void getClass(final EIURI id, final ClassCallback callback) {
        if (this.mapIdToClass.containsKey(id)) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess((EIClass)ClientModelManager.this.mapIdToClass.get(id));
                }
            });
        } else {
            modelService.getClass(id, new AsyncCallback<EIClass>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(EIClass result) {
                    callback.onSuccess(ClientModelManager.this.getCachedClass(result));
                }
            });
        }
    }

    public void getSubClasses(final EIClass resource, final SubClassCallback callback) {
        if (!resource.hasSubClass() || resource.getSubClasses() != null) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess(resource);
                }
            });
        } else {
            modelService.getSubClasses(resource.getEntity().getURI(), new AsyncCallback<List<EIClass>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<EIClass> result) {
                    ArrayList<EIClass> cacheResults = new ArrayList<EIClass>(result.size());
                    for (EIClass c : result) {
                        cacheResults.add(ClientModelManager.this.getCachedClass(c));
                    }
                    resource.setSubClasses(cacheResults);
                    callback.onSuccess(resource);
                }
            });
        }
    }

    public void getSuperClasses(EIURI resourceURI, final SuperClassesCallback callback) {
        EIClass resourceClass = this.mapIdToClass.get(resourceURI);
        if (resourceClass != null) {
            this.getSuperClasses(resourceClass, callback);
        } else {
            this.getClass(resourceURI, new ClassCallback(){

                @Override
                public void onSuccess(EIClass result) {
                    ClientModelManager.this.getSuperClasses(ClientModelManager.this.getCachedClass(result), callback);
                }
            });
        }
    }

    public void getSuperClasses(final EIClass resource, final SuperClassesCallback callback) {
        EIClass needsSuperClass = resource;
        while (needsSuperClass != null) {
            if (!needsSuperClass.hasSuperClass()) {
                needsSuperClass = null;
                continue;
            }
            if (needsSuperClass.getSuperClass() == null) break;
            needsSuperClass = needsSuperClass.getSuperClass();
        }
        if (needsSuperClass == null) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess(resource);
                }
            });
        } else {
            final EIClass targetClass = needsSuperClass;
            modelService.getSuperClasses(targetClass.getEntity().getURI(), new AsyncCallback<List<EIClass>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<EIClass> result) {
                    EIClass cacheChild = targetClass;
                    for (EIClass parent : result) {
                        EIClass cacheParent = ClientModelManager.this.getCachedClass(parent);
                        cacheChild.setSuperClass(cacheParent);
                        cacheChild = cacheParent;
                    }
                    callback.onSuccess(resource);
                }
            });
        }
    }

    public void getProperties(final EIClass resource, final PropertyCallback callback) {
        if (!resource.hasProperty() || resource.getProperties() != null) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess(resource);
                }
            });
        } else {
            modelService.getProperties(resource.getEntity().getURI(), new AsyncCallback<List<EIProperty>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<EIProperty> result) {
                    resource.setProperties(ClientModelManager.this.getCachedProperties(result));
                    callback.onSuccess(resource);
                }
            });
        }
    }

    public void getEquivalentClasses(final EIClass resource, final EquivalentClassCallback callback) {
        if (!resource.hasEquivalentClass() || resource.getEquivalentClasses() != null) {
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    callback.onSuccess(resource);
                }
            });
        } else {
            modelService.getEquivalentClasses(resource.getEntity().getURI(), new AsyncCallback<List<EIEquivalentClass>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<EIEquivalentClass> result) {
                    resource.setEquivalentClasses(ClientModelManager.this.getCachedEquivalents(result));
                    callback.onSuccess(resource);
                }
            });
        }
    }

    public void getClassDefinitions(final List<EIClass> classList, final ClassDefinitionCallback callback) {
        ArrayList<EIURI> classURIList = new ArrayList<EIURI>(classList.size());
        for (EIClass clazz : classList) {
            classURIList.add(clazz.getEntity().getURI());
        }
        modelService.getClassDefinitions(classURIList, new AsyncCallback<List<String>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<String> result) {
                int index = 0;
                for (EIClass clazz : classList) {
                    clazz.setDefinition(result.get(index++));
                }
                callback.onSuccess(classList);
            }
        });
    }

    public void getPropertyDefinitions(final List<EIProperty> propertyList, final PropertyDefinitionCallback callback) {
        ArrayList<EIURI> propURIList = new ArrayList<EIURI>(propertyList.size());
        for (EIProperty prop : propertyList) {
            propURIList.add(prop.getEntity().getURI());
        }
        modelService.getPropertyDefinitions(propURIList, new AsyncCallback<List<String>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<String> result) {
                int index = 0;
                for (EIProperty prop : propertyList) {
                    prop.setDefinition(result.get(index++));
                }
                callback.onSuccess(propertyList);
            }
        });
    }

    public void getClassAnnotations(final List<EIClass> classList, final ClassAnnotationsCallback callback) {
        ArrayList<EIURI> classURIList = new ArrayList<EIURI>(classList.size());
        for (EIClass clazz : classList) {
            classURIList.add(clazz.getEntity().getURI());
        }
        modelService.getClassAnnotations(classURIList, new AsyncCallback<List<Set<String>>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<Set<String>> result) {
                int index = 0;
                for (EIClass clazz : classList) {
                    clazz.setAnnotations(result.get(index++));
                }
                callback.onSuccess(classList);
            }
        });
    }

    public void getLabels(final EIURI uri, final LabelsCallback callback) {
        modelService.getLabels(uri, new AsyncCallback<List<String>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<String> result) {
                callback.onSuccess(uri, result);
            }
        });
    }

    private List<EIProperty> getCachedProperties(List<EIProperty> propList) {
        for (EIProperty p : propList) {
            EIValueRestriction restriction;
            if (p instanceof EIObjectProperty) {
                EIObjectProperty op = (EIObjectProperty)p;
                List cList = op.getRangeList();
                for (int i = 0; i < cList.size(); ++i) {
                    cList.set(i, this.getCachedClass((EIClass)cList.get(i)));
                }
            }
            if ((restriction = p.getValueRestriction()) == null || restriction.getClass() == null) continue;
            EIValueRestriction cachedRestriction = new EIValueRestriction(restriction.getType(), restriction.getURI(), this.getCachedClass(restriction.getEIClass()));
            p.setValueRestriction(cachedRestriction);
        }
        return propList;
    }

    private List<EIEquivalentClass> getCachedEquivalents(List<EIEquivalentClass> equivList) {
        for (EIEquivalentClass e : equivList) {
            List cList = e.getEquivalentTo();
            for (int i = 0; i < cList.size(); ++i) {
                cList.set(i, this.getCachedClass((EIClass)cList.get(i)));
            }
        }
        return equivList;
    }

    private EIClass getCachedClass(EIClass c) {
        if (this.mapIdToClass.containsKey(c.getEntity().getURI())) {
            return this.mapIdToClass.get(c.getEntity().getURI());
        }
        this.mapIdToClass.put(c.getEntity().getURI(), c);
        return c;
    }

    public static interface LabelsCallback {
        public void onSuccess(EIURI var1, List<String> var2);
    }

    public static interface ClassAnnotationsCallback {
        public void onSuccess(List<EIClass> var1);
    }

    public static interface PropertyDefinitionCallback {
        public void onSuccess(List<EIProperty> var1);
    }

    public static interface ClassDefinitionCallback {
        public void onSuccess(List<EIClass> var1);
    }

    public static interface EquivalentClassCallback {
        public void onSuccess(EIClass var1);
    }

    public static interface PropertyCallback {
        public void onSuccess(EIClass var1);
    }

    public static interface SuperClassesCallback {
        public void onSuccess(EIClass var1);
    }

    public static interface SubClassCallback {
        public void onSuccess(EIClass var1);
    }

    public static interface ClassCallback {
        public void onSuccess(EIClass var1);
    }

    public static interface NonResourceBaseClassesCallback {
        public void onSuccess(List<EIClass> var1);
    }

    public static interface TopLevelClassesCallback {
        public void onSuccess(List<EIClass> var1);
    }

    public static interface VersionCallback {
        public void onSuccess(String var1);
    }
}

