package org.eaglei.model.gwt.rpc;

import java.util.List;
import java.util.Set;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;


/**
 * The client side stub for the RPC service.
 */
@RemoteServiceRelativePath("model")
public interface ModelService extends RemoteService {
    String getVersion() throws LoggedException;
    //List<EIEntity> getInstitutions() throws LoggedException;
    List<EIClass> getTopLevelClasses() throws LoggedException;
    List<EIClass> getNonResourceBaseClasses() throws LoggedException;
    EIClass getClass(EIURI classId) throws LoggedException;
    /**
     * Gets the ancestors of the given class up to, and including,
     * a top-level class.  The first member of the returned list
     * will be the parent of the given class.
     * 
     * @param classId
     * @return
     * @throws LoggedException
     */
    List<EIClass> getSuperClasses(EIURI classId) throws LoggedException;
    List<EIClass> getSubClasses(EIURI classId) throws LoggedException;
    List<EIProperty> getProperties(EIURI classId) throws LoggedException;
    List<EIEquivalentClass> getEquivalentClasses(EIURI classId) throws LoggedException;
    List<String> getClassDefinitions(List<EIURI> classURIs) throws LoggedException;
    List<String> getPropertyDefinitions(List<EIURI> propertyURIs) throws LoggedException;
    List<String> getLabels(EIURI uri) throws LoggedException;
    List<Set<String>> getClassAnnotations(List<EIURI> classURIs) throws LoggedException;
    /**
     * Gets the property annotations for all properties in the given class.
     * Returns a map of property URI to map of annotation predicate to value.
     * @param classURI
     * @return
     * @throws LoggedException
     */
    //Map<EIURI,Map<String,String>> getPropertyAnnotations(EIURI classURI) throws LoggedException;
}
