package org.eaglei.model.gwt.rpc;

import java.util.List;
import java.util.Set;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;

import com.google.gwt.user.client.rpc.AsyncCallback;


/**
 * The async counterpart of <code>ModelService</code>.
 * 
 * Client code should generally not call this directly.
 * Use ClientModelManager instead.
 */
public interface ModelServiceAsync {
    void getVersion(AsyncCallback<String> callback);
    void getClassesInGroup(String groupId, AsyncCallback<List<EIClass>> callback);
    void getClassesInGroup(String groupId, boolean includeSubclasses, AsyncCallback<List<EIClass>> callback);
    /**
     * 
     * @param callback
     * @deprecated Use getClassesInGroup(EIOntConstants.CG_RESOURCE_ROOT)
     */
    void getTopLevelClasses(AsyncCallback<List<EIClass>> callback);
    /**
     * 
     * @param callback
     * @deprecated Use getClassesInGroup(EIOntConstants.CG_NON_RESOURCE_ROOT)
     */
    void getNonResourceBaseClasses(AsyncCallback<List<EIClass>> callback);
    void getClass(EIURI classId, AsyncCallback<EIClass> callback);
    void getSuperClasses(EIURI classId, AsyncCallback<List<EIClass>> callback);
    void getSubClasses(EIURI classId, AsyncCallback<List<EIClass>> callback);
    void getProperties(EIURI classId, AsyncCallback<List<EIProperty>> callback);
    void getEquivalentClasses(EIURI classId, AsyncCallback<List<EIEquivalentClass>> callback);
    void getClassDefinitions(List<EIURI> classURIs, AsyncCallback<List<String>> callback);
    void getPropertyDefinitions(List<EIURI> propertyURIs, AsyncCallback<List<String>> callback);
    void getLabels(EIURI uri, AsyncCallback<List<String>> callback);
    void getClassAnnotations(List<EIURI> classURIs, AsyncCallback<List<Set<String>>> callback);
    //void getPropertyAnnotations(EIURI classURI, AsyncCallback<Map<EIURI,Map<String,String>>> callback);
    
    /*to check if the URI is ontology term or repository instance*/
	public void isModelClassURI(EIURI uri,AsyncCallback<Boolean> callback);
}
