package org.eaglei.model.gwt.server;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * Subclass of ModelServlet suitable for use in a junit GWTTestCase.
 * 
 * In a GWTTestCase execution, the GWTShellServlet is not loading a web.xml file
 * and invoking specified listener classes.  Since the spring
 * ContextLoaderListener is not being invoked, WebApplicationContext is not
 * automatically being created and initialized with an application.xml configuration file.
 * 
 * In this class, the servlet init() method has been overriden to explictly
 * construct an ApplicationContext with the configuration files
 * needed for this GWT RPC servlet.
 * 
 * If the underlying servlet is changed to construct its own ApplicationContext
 * instead of getting it using WebApplicationContextUtils, then this class
 * may no longer be necessary.
 */
public class TestModelServlet extends ModelServlet {

    @Override
    public void init() {
        ApplicationContext springAppContext = 
            new ClassPathXmlApplicationContext(new String[] {"jena-model-config.xml"});
        doDependencyInjection(springAppContext);
    }
    
}
