/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class WriteDefinitions
extends TestCase {
    private static final Log logger = LogFactory.getLog(WriteDefinitions.class);
    private EIOntModel eagleiOntModel;
    private FileWriter fwClassDefinitions;
    private FileWriter fwPropertyDefinitions;
    private HashMap<EIEntity, String> mapRequiredProperties = new HashMap();
    private HashMap<EIEntity, String> mapNonRequiredProperties = new HashMap();
    public int count = 0;
    public int numProperties = 0;
    public int numClassesWithAltLabels = 0;

    protected void setUp() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"jena-model-config.xml"});
        this.eagleiOntModel = (EIOntModel)context.getBean("eagleiOntModel");
    }

    public void testWriteDefinitions() {
        try {
            String version = this.eagleiOntModel.getVersion();
            version = version.substring(0, version.indexOf(32));
            File dir = WriteDefinitions.ensureOutputDirectory("target/output/definitions");
            File f = new File(dir, "ClassDefinitions-" + version + ".txt");
            this.fwClassDefinitions = new FileWriter(f);
            f = new File(dir, "PropertyDefinitions-" + version + ".txt");
            this.fwPropertyDefinitions = new FileWriter(f);
            ArrayList<DataModelVisitor> visitors = new ArrayList<DataModelVisitor>();
            DataModelVisitor v = new DataModelVisitor();
            visitors.add(v);
            this.eagleiOntModel.traverseDataModel(visitors);
            logger.info((Object)"Write of class definitions complete.  Writing properties file.");
            this.fwPropertyDefinitions.write("====== BEGIN REQUIRED PROPERTIES ======\r\n");
            for (EIEntity rp : this.mapRequiredProperties.keySet()) {
                this.writePropertyDefinition(rp, this.mapRequiredProperties.get(rp));
            }
            this.fwPropertyDefinitions.write("====== END REQUIRED PROPERTIES ======\r\n");
            for (EIEntity rp : this.mapNonRequiredProperties.keySet()) {
                this.writePropertyDefinition(rp, this.mapNonRequiredProperties.get(rp));
            }
            logger.info((Object)"Write of definitions complete.");
            this.fwClassDefinitions.close();
            this.fwPropertyDefinitions.close();
        }
        catch (IOException e) {
            logger.error((Object)e);
            WriteDefinitions.assertTrue((boolean)false);
        }
    }

    private void writeClassDefinition(EIClass c) {
        try {
            String definition;
            this.fwClassDefinitions.write("CLASS:  ");
            if (c.isInferred()) {
                this.fwClassDefinitions.write("(Inferred)  ");
            }
            this.fwClassDefinitions.write(c.getEntity().toString());
            this.fwClassDefinitions.write("\r\n");
            List superClasses = this.eagleiOntModel.getSuperClasses(c.getEntity().getURI());
            if (superClasses != null && superClasses.size() > 0) {
                this.fwClassDefinitions.write("Super types:  ");
                for (int i = 0; i < superClasses.size(); ++i) {
                    EIClass sc = (EIClass)superClasses.get(i);
                    this.fwClassDefinitions.write(sc.getEntity().getLabel());
                    if (i >= superClasses.size() - 1) continue;
                    this.fwClassDefinitions.write("  |  ");
                }
                this.fwClassDefinitions.write("\r\n");
            }
            if ((definition = this.eagleiOntModel.getClassDefinition(c.getEntity().getURI())) == null) {
                definition = "NO DEFINITION";
            }
            this.fwClassDefinitions.write("\r\n");
            this.fwClassDefinitions.write(definition);
            this.fwClassDefinitions.write("\r\n");
            this.fwClassDefinitions.write("\r\n");
            List properties = this.eagleiOntModel.getProperties(c.getEntity().getURI());
            for (int i = 0; i < properties.size(); ++i) {
                EIProperty p = (EIProperty)properties.get(i);
                definition = this.eagleiOntModel.getPropertyDefinition(p.getEntity().getURI());
                if (definition == null) {
                    definition = "NO DEFINITION";
                }
                if (p.getValueRestriction() != null) {
                    this.fwClassDefinitions.write("REQUIRED: ");
                    this.mapRequiredProperties.put(p.getEntity(), definition);
                    this.mapNonRequiredProperties.remove(p.getEntity());
                } else if (this.mapRequiredProperties.get(p.getEntity()) == null) {
                    this.mapNonRequiredProperties.put(p.getEntity(), definition);
                }
                this.fwClassDefinitions.write(p.getEntity().toString());
                this.fwClassDefinitions.write("\r\n");
            }
            this.fwClassDefinitions.write("--------------------------------------------------\r\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writePropertyDefinition(EIEntity entity, String definition) {
        try {
            this.fwPropertyDefinitions.write("PROPERTY:  ");
            this.fwPropertyDefinitions.write(entity.toString());
            this.fwPropertyDefinitions.write("\r\n");
            this.fwPropertyDefinitions.write("\r\n");
            if (definition == null) {
                definition = "NO DEFINITION";
            }
            this.fwPropertyDefinitions.write(definition);
            this.fwPropertyDefinitions.write("\r\n");
            this.fwPropertyDefinitions.write("\r\n");
            this.fwPropertyDefinitions.write("--------------------------------------------------\r\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File ensureOutputDirectory(String outputPath) throws IOException {
        if (outputPath == null || outputPath.length() == 0) {
            logger.error((Object)"Empty or null output path");
            return null;
        }
        File outputDir = new File(outputPath);
        logger.info((Object)("Generating test data to directory: " + outputDir.getAbsolutePath()));
        if (outputDir.exists()) {
            File[] dirContent;
            for (File f : dirContent = outputDir.listFiles()) {
                f.delete();
            }
            if (!outputDir.delete()) {
                logger.error((Object)("Failed to delete output directory " + outputDir.getAbsolutePath()));
                throw new RuntimeException("Failed to delete output directory " + outputDir.getAbsolutePath());
            }
        }
        if (!outputDir.mkdirs()) {
            logger.error((Object)("Failed to create output directory " + outputDir.getAbsolutePath()));
            throw new RuntimeException("Failed to create output directory " + outputDir.getAbsolutePath());
        }
        return outputDir;
    }

    class DataModelVisitor
    implements EIOntModel.Visitor {
        DataModelVisitor() {
        }

        public void visit(EIClass c, Deque<String> stack) {
            WriteDefinitions.this.writeClassDefinition(c);
            if (WriteDefinitions.this.count % 20 == 0) {
                logger.info((Object)(WriteDefinitions.this.count + " classes have been checked."));
            }
            ++WriteDefinitions.this.count;
        }

        public void visit(EIProperty p, Deque<String> stack) {
        }
    }
}

