/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceFactory;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.MetadataConstants;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JenaEIInstanceFactory
implements EIInstanceFactory {
    private static final Log logger = LogFactory.getLog(JenaEIInstanceFactory.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    public static final JenaEIInstanceFactory INSTANCE = new JenaEIInstanceFactory();
    private static EIOntModel ontModel;

    public static JenaEIInstanceFactory getInstance() {
        return INSTANCE;
    }

    private JenaEIInstanceFactory() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"jena-model-config.xml"});
        ontModel = (EIOntModel)context.getBean(EIOntModel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialize(EIInstance instance, String lang) {
        if (instance == null) {
            return null;
        }
        Model model = this.convertToJenaModel(instance);
        StringWriter sw = new StringWriter();
        try {
            model.write((Writer)sw, lang);
            String s = sw.toString();
            sw.flush();
            String string = s;
            return string;
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public Model convertToJenaModel(EIInstance instance) {
        Property p;
        if (instance == null) {
            return null;
        }
        Model model = ModelFactory.createDefaultModel();
        Resource resourceInstance = model.createResource(instance.getInstanceURI().toString());
        Resource eiType = model.createResource(instance.getInstanceType().getURI().toString());
        model.add(model.createStatement(resourceInstance, RDF.type, (RDFNode)eiType));
        model.add(model.createStatement(resourceInstance, RDFS.label, instance.getInstanceLabel()));
        List otherEITypes = instance.getOtherEITypes();
        if (otherEITypes != null) {
            for (EIEntity t : otherEITypes) {
                Resource typeResource = model.createResource(t.getURI().toString());
                model.add(model.createStatement(resourceInstance, RDF.type, (RDFNode)typeResource));
            }
        }
        Map dataProps = instance.getDatatypeProperties();
        Map objectProps = instance.getObjectProperties();
        Map literalProps = instance.getNonOntologyLiteralProperties();
        Map resourceProps = instance.getNonOntologyResourceProperties();
        Map roResourceProps = instance.getReadOnlyResourceProperties();
        Map roLiteralProps = instance.getReadOnlyLiteralProperties();
        this.addLiteralTriples(model, resourceInstance, dataProps);
        this.addResourceTriples(model, resourceInstance, objectProps);
        this.addLiteralTriples(model, resourceInstance, literalProps);
        this.addResourceTriples(model, resourceInstance, resourceProps);
        for (Map.Entry entry : roLiteralProps.entrySet()) {
            p = model.createProperty(((EIEntity)entry.getKey()).getURI().toString());
            if (entry.getValue() == null || ((String)entry.getValue()).length() <= 0) continue;
            model.add(model.createStatement(resourceInstance, p, (String)entry.getValue()));
        }
        for (Map.Entry entry : roResourceProps.entrySet()) {
            p = model.createProperty(((EIEntity)entry.getKey()).getURI().toString());
            if (entry.getValue() == null || ((EIEntity)entry.getValue()).toString().length() <= 0) continue;
            Resource value = model.createResource(((EIEntity)entry.getValue()).getURI().toString());
            model.add(model.createStatement(resourceInstance, p, (RDFNode)value));
        }
        return model;
    }

    private void addResourceTriples(Model model, Resource resourceInstance, Map<EIEntity, Set<EIEntity>> resources) {
        for (Map.Entry<EIEntity, Set<EIEntity>> entry : resources.entrySet()) {
            Property p = model.createProperty(entry.getKey().getURI().toString());
            Set<EIEntity> values = entry.getValue();
            if (values == null) continue;
            for (EIEntity value : values) {
                if (value == null || value.toString().length() <= 0) continue;
                Resource valueResource = model.createResource(value.getURI().toString());
                model.add(model.createStatement(resourceInstance, p, (RDFNode)valueResource));
            }
        }
    }

    private void addLiteralTriples(Model model, Resource resourceInstance, Map<EIEntity, Set<String>> literals) {
        for (Map.Entry<EIEntity, Set<String>> entry : literals.entrySet()) {
            Property p = model.createProperty(entry.getKey().getURI().toString());
            Set<String> values = entry.getValue();
            for (String value : values) {
                if (value == null || value.length() <= 0) continue;
                model.add(model.createStatement(resourceInstance, p, value));
            }
        }
    }

    public EIInstance create(EIURI instanceUri, String rdf, String lang) {
        if (instanceUri == null || instanceUri.toString().length() == 0 || rdf == null || rdf.length() == 0) {
            return null;
        }
        Model model = ModelFactory.createDefaultModel();
        model.read((Reader)new StringReader(rdf), null, lang);
        return this.create(instanceUri, model);
    }

    public EIInstance createEmpty(EIURI typeUri, EIEntity instanceEntity) {
        if (instanceEntity == null) {
            return null;
        }
        EIClass instanceClass = this.safeGetClass(typeUri);
        if (instanceClass == null) {
            return null;
        }
        String label = instanceClass.getEntity().getLabel();
        instanceClass.getEntity().setLabel(label);
        EIInstance ei = EIInstance.create((EIEntity)instanceClass.getEntity(), (EIEntity)instanceEntity);
        ei.setInstanceClass(instanceClass);
        return ei;
    }

    public EIInstance create(EIURI instanceUri, Model model) {
        Resource subject = this.getInstanceSubject(instanceUri, model);
        if (subject == null) {
            return null;
        }
        List<EIClass> eiClasses = this.getInstanceClasses(model, subject);
        if (eiClasses == null || eiClasses.isEmpty() || eiClasses.get(0) == null) {
            return null;
        }
        EIClass instanceClass = eiClasses.get(0);
        eiClasses.remove(0);
        String instanceLabel = this.getInstanceLabel(subject);
        if (instanceLabel == null) {
            return null;
        }
        if (isDebugEnabled) {
            logger.debug((Object)("Creating an instance of class: " + instanceClass.getEntity().toString() + " with URI: " + instanceUri + " and label: " + instanceLabel));
        }
        EIInstance ei = EIInstance.create((EIClass)instanceClass, (EIEntity)EIEntity.create((EIURI)instanceUri, (String)instanceLabel));
        this.setInstanceTypes(eiClasses, ei);
        return this.processModelStatements(model, subject, eiClasses, instanceClass, ei);
    }

    private EIInstance processModelStatements(Model model, Resource subject, List<EIClass> eiClasses, EIClass instanceClass, EIInstance ei) {
        StmtIterator iterator = model.listStatements(subject, null, (RDFNode)null);
        while (iterator.hasNext()) {
            Statement statement = iterator.nextStatement();
            Property predicate = statement.getPredicate();
            if (predicate.equals(RDFS.label)) continue;
            EIURI propertyUri = EIURI.create((String)predicate.getURI());
            RDFNode o = statement.getObject();
            if (predicate.equals(RDF.type) && o.isResource() && instanceClass.getEntity().getURI().toString().equals(((Resource)o).getURI()) || predicate.equals(RDF.type) && o.isResource() && this.containsUri(eiClasses, ((Resource)o).getURI())) continue;
            EIProperty p = this.getEIOntProperty(instanceClass.getEntity().getURI(), propertyUri);
            if (p != null) {
                this.addEIProperty(ei, p, propertyUri, o);
                continue;
            }
            String propertyLabel = this.getObjectLabel((RDFNode)predicate);
            this.addNonEIProperty(ei, propertyLabel, propertyUri, o);
        }
        return ei;
    }

    private String getObjectLabel(RDFNode o) {
        Statement objectLabelStatement;
        EIClass classForObject = this.safeGetClass(EIURI.create((String)((Resource)o).getURI()));
        String objectLabel = classForObject != null ? classForObject.getEntity().getLabel() : ((objectLabelStatement = ((Resource)o).getProperty(RDFS.label)) != null ? objectLabelStatement.getLiteral().getLexicalForm() : ((Resource)o).getURI().toString());
        return objectLabel;
    }

    private void setInstanceTypes(List<EIClass> eiClasses, EIInstance ei) {
        if (!eiClasses.isEmpty()) {
            ArrayList<EIEntity> eiTypes = new ArrayList<EIEntity>(eiClasses.size());
            for (EIClass c : eiClasses) {
                eiTypes.add(c.getEntity());
            }
            ei.setOtherEITypes(eiTypes);
        }
    }

    private String getInstanceLabel(Resource subject) {
        Statement labelStatement = subject.getProperty(RDFS.label);
        if (labelStatement == null) {
            if (isDebugEnabled) {
                logger.debug((Object)"RDFS Label is not set for instance");
            }
            return null;
        }
        return labelStatement.getString();
    }

    private List<EIClass> getInstanceClasses(Model model, Resource subject) {
        List<EIClass> eiClasses = this.getEIClasses(model, subject);
        if (eiClasses == null) {
            if (isDebugEnabled) {
                logger.debug((Object)"No eagle-i types found in the model");
            }
            return null;
        }
        return eiClasses;
    }

    private Resource getInstanceSubject(EIURI instanceUri, Model model) {
        if (instanceUri == null || model == null) {
            if (isDebugEnabled) {
                logger.debug((Object)"null parameters; no EIInstance was created");
            }
            return null;
        }
        Resource subject = model.getResource(instanceUri.toString());
        if (!model.contains(subject, null, (RDFNode)null)) {
            if (isDebugEnabled) {
                logger.debug((Object)"model doesn't contain subject; no EIInstance was created");
            }
            return null;
        }
        return subject;
    }

    public List<EIInstance> create(Model model) {
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EIInstance> instances = new ArrayList<EIInstance>();
        Set subjects = model.listSubjects().toSet();
        for (Resource r : subjects) {
            Model results = model.query((Selector)new SimpleSelector(r, null, (RDFNode)null));
            EIInstance ei = this.create(EIURI.create((String)r.getURI()), results);
            if (ei == null) continue;
            instances.add(ei);
        }
        return instances;
    }

    private EIProperty getEIOntProperty(EIURI instanceClassUri, EIURI propertyUri) {
        if (instanceClassUri == null || propertyUri == null) {
            return null;
        }
        List properties = ontModel.getProperties(instanceClassUri);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        for (EIProperty p : properties) {
            EIURI propUri = p.getEntity().getURI();
            if (!propUri.equals((Object)propertyUri)) continue;
            return p;
        }
        return null;
    }

    private List<EIClass> getEIClasses(Model model, Resource subject) {
        List typeStatements = model.listStatements(subject, RDF.type, (RDFNode)((Resource)null)).toList();
        if (typeStatements == null || typeStatements.isEmpty()) {
            return null;
        }
        ArrayList<EIClass> eiClasses = new ArrayList<EIClass>();
        for (Statement st : typeStatements) {
            Resource type = (Resource)st.getObject();
            EIURI typeUri = EIURI.create((String)type.getURI());
            EIClass eiClass = this.safeGetClass(typeUri);
            if (eiClass == null) continue;
            eiClasses.add(eiClass);
        }
        return eiClasses.isEmpty() ? null : eiClasses;
    }

    private void addEIProperty(EIInstance ei, EIProperty predicate, EIURI propertyUri, RDFNode o) {
        String preferredLabel = ontModel.getPreferredLabel(propertyUri);
        EIEntity propEntity = EIEntity.create((EIURI)propertyUri, (String)preferredLabel);
        if (predicate instanceof EIDatatypeProperty) {
            if (o.isLiteral()) {
                String value = o.toString();
                ei.addDatattypeProperty(propEntity, value);
            } else {
                String objectLabel = this.getObjectLabel(o);
                EIEntity entity = EIEntity.create((EIURI)EIURI.create((String)((Resource)o).getURI()), (String)objectLabel);
                ei.addNonOntologyResourceProperty(propEntity, entity);
            }
        } else if (predicate instanceof EIObjectProperty) {
            if (o.isResource()) {
                String objectLabel = this.getObjectLabel(o);
                EIEntity entity = EIEntity.create((EIURI)EIURI.create((String)((Resource)o).getURI()), (String)objectLabel);
                ei.addObjectProperty(propEntity, entity);
            } else {
                ei.addNonOntologyLiteralProperty(propEntity, o.toString());
            }
        }
    }

    private void addNonEIProperty(EIInstance ei, String propertyLabel, EIURI propertyUri, RDFNode o) {
        EIEntity propEntity = MetadataConstants.readOnlyResources.containsKey(propertyUri) ? MetadataConstants.readOnlyResources.get(propertyUri) : (MetadataConstants.readOnlyLiterals.containsKey(propertyUri) ? MetadataConstants.readOnlyLiterals.get(propertyUri) : EIEntity.create((EIURI)propertyUri, (String)propertyLabel));
        if (o.isLiteral()) {
            if (MetadataConstants.readOnlyLiterals.containsKey(propertyUri)) {
                ei.setReadOnlyLiteralProperty(propEntity, o.toString());
            } else {
                ei.addNonOntologyLiteralProperty(propEntity, o.toString());
            }
        } else if (o.isResource()) {
            String objectLabel = this.getObjectLabel(o);
            EIEntity entity = EIEntity.create((EIURI)EIURI.create((String)((Resource)o).getURI()), (String)objectLabel);
            if (MetadataConstants.readOnlyResources.containsKey(propertyUri)) {
                ei.setReadOnlyResourceProperty(propEntity, entity);
            } else {
                ei.addNonOntologyResourceProperty(propEntity, entity);
            }
        } else if (isDebugEnabled) {
            logger.debug((Object)("Could not add property " + propertyUri));
        }
    }

    private boolean containsUri(List<EIClass> eiClasses, String uri) {
        if (eiClasses == null || uri == null) {
            return false;
        }
        for (EIClass eiClass : eiClasses) {
            if (!uri.equalsIgnoreCase(eiClass.getEntity().getURI().toString())) continue;
            return true;
        }
        return false;
    }

    private EIClass safeGetClass(EIURI typeUri) {
        if (ontModel.isModelClassURI(typeUri.toString())) {
            return ontModel.getClass(typeUri);
        }
        return null;
    }
}

