/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIInstanceFactory;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.model.jena.JenaEIOntModel;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JenaModelConfig {
    private static final Log logger;
    public static final String EAGLE_I_APP_EXT_URI = "http://purl.org/eagle-i/app-ext/";
    @Autowired
    private OntDocumentManager jenaOntDocumentManager;

    @Bean
    public OntModel jenaOntModel() {
        logger.info((Object)"loading ontology...");
        long start = System.currentTimeMillis();
        OntModel model = this.jenaOntDocumentManager.getOntology(EAGLE_I_APP_EXT_URI, PelletReasonerFactory.THE_SPEC);
        logger.info((Object)("eagle-i ontology loaded:  " + (System.currentTimeMillis() - start) + "msec"));
        return model;
    }

    @Bean
    public EIOntModel eagleiOntModel() {
        JenaEIOntModel eagleiOntModel = new JenaEIOntModel(this.jenaOntModel());
        return eagleiOntModel;
    }

    @Bean
    public EIInstanceFactory eagleiInstanceFactory() {
        JenaEIInstanceFactory eagleiInstanceFactory = JenaEIInstanceFactory.getInstance();
        return eagleiInstanceFactory;
    }

    static {
        Logger logger;
        JenaModelConfig.logger = LogFactory.getLog(JenaModelConfig.class);
        if (System.getProperty("pellet.configuration") == null) {
            Properties defaultOptions = new Properties();
            defaultOptions.setProperty("USE_CLASSIFICATION_MONITOR", PelletOptions.MonitorType.NONE.toString());
            defaultOptions.setProperty("IGNORE_UNSUPPORTED_AXIOMS", "true");
            PelletOptions.setOptions((Properties)defaultOptions);
        }
        if ((logger = LogManager.getLogManager().getLogger("org.mindswap.pellet.jena.graph.loader.DefaultGraphLoader")) == null) {
            logger = Logger.getLogger("org.mindswap.pellet.jena.graph.loader.DefaultGraphLoader");
            logger.setLevel(Level.SEVERE);
        }
    }
}

