package org.eaglei.model;

/**
 * Holds eagle-i ontology constants
 */
public final class EagleIOntConstants {

    /**
     * Namespace of eagle-i-app-ont.owl ontology.
     * Used for eagle-i class/property annotation definitions.
     */
    public static final String EAGLE_I_APP_ONT_URI = "http://eagle-i.org/ont/app/1.0/";
    
    /**
     * URI of the eagle-i.owl ontology
     */
    public static final String EAGLE_I_URI = "http://purl.obolibrary.org/obo/";
    
    /**
     * special :isDeleted predicate
     */
    public static final String IS_DELETED = "http://eagle-i.org/ont/repo/1.0/isDeleted";       
    
    /**
     * URI of the OBI definition annotation property
     */
    public static final String OBI_DEFINITION_URI = "http://purl.obolibrary.org/obo/IAO_0000115";

    /**
     * URI of the IAO perferred term annotation property
     */
    public static final String IAO_PREFERRED_TERM_URI = "http://purl.obolibrary.org/obo/IAO_0000111";
    
    /**
     * URI of the IAO alternate term annotation property
     */
    public static final String IAO_ALTERNATE_TERM_URI = "http://purl.obolibrary.org/obo/IAO_0000118";
        
    /**
     * URI of the eagle-i preferred definition annotation property
     */
    public static final String EI_PREFERRED_DEFINITION_URI = EAGLE_I_APP_ONT_URI + "preferredDefinition";

    /**
     * URI of the annotation property used to mark class group.
     */
    public static final String IN_CLASS_GROUP = EAGLE_I_APP_ONT_URI + "inClassGroup";
    
    /**
     * URI of the annotation property used to mark class group.
     */
    public static final String IN_PROPERTY_GROUP = EAGLE_I_APP_ONT_URI + "inPropertyGroup";
    
    /**
     * URI of PropertyGroup instance that is set as the value of the IN_PROPERTY_GROUP annotation
     * for properties that should be exposed for data collection.
     */
    public static final String DATA_MODEL_EXCLUDE = EAGLE_I_APP_ONT_URI + "PropertyGroup/dataModelExclude";
    
    /**
     * URI of the annotation property used to indicate display order for properties and classes.
     * Value is an integer and lower values have a higher display priority.
     */
    public static final String DISPLAY_ORDER = EAGLE_I_APP_ONT_URI + "displayOrder";
    
    /**
     * URI of ClassGroup instance that is set as the value of the IN_CLASS_GROUP annotation
     * for classes that are top-level eagle-i resources.
     */
    public static final String TOP_LEVEL_GROUP = EAGLE_I_APP_ONT_URI + "ClassGroup/resourceRoot";
    
    /**
     * URI of annotation property that is used to specify eagle-i specific preferred labels
     */
    public static final String EI_PREFERRED_LABEL = EAGLE_I_APP_ONT_URI + "preferredLabel";    
    
    /**
     * URI of annotation property that is used to specify a list of domain URIs that
     * should take precedence over the domain specification in the ontoloyg model.
     */
    public static final String DOMAIN_CONSTRAINT = EAGLE_I_APP_ONT_URI + "domainConstraint";    
    
    /**
     * URI of annotation property that is used to specify a list of range URIs that
     * should take precedence over the range list in the ontology model.
     */
    public static final String RANGE_CONSTRAINT = EAGLE_I_APP_ONT_URI + "rangeConstraint";    
    
    /**
     * URI of ClassGroup instance that is set as the value of the IN_CLASS_GROUP annotation
     * for classes that are used in the data model, but are not eagle-i resources.  
     * These are the classes that appear as object property ranges in the data model, 
     * but aren't resource (top-level) classes.
     */
    public static final String NON_RESOURCE_GROUP = EAGLE_I_APP_ONT_URI + "ClassGroup/nonResourceBase";
    
    /**
     * URI of PropertyGroup instance that is set as the value of the IN_PROPERTY_GROUP annotation
     * for properties that should be exposed for data collection.
     */
    public static final String DATA_COLLECTION_PROPERTY = EAGLE_I_APP_ONT_URI + "PropertyGroup/dataCollection";
    
    /**
     * URI of PropertyGroup instance that is set as the value of the IN_PROPERTY_GROUP annotation
     * for properties that should be exposed for data collection.
     */
    public static final String SEARCH_FILTER_PROPERTY = EAGLE_I_APP_ONT_URI + "PropertyGroup/searchFilter";

    /**
     * URI of PropertyGroup instance that is set as the value of the IN_PROPERTY_GROUP annotation
     * for properties that hold administrative data. These properties should not be indexed for search or
     * exposed in non-admin UIs.
     */
    public static final String ADMIN_DATA_GROUP = EAGLE_I_APP_ONT_URI + "PropertyGroup/adminData";    
    
    /**
     * URI of ClassGroup indicating that this class should not be allowed as the asserted
     * type of an eagle-i resource instance.
     */
    public static final String NO_ASSERTED_INSTANCES_GROUP = EAGLE_I_APP_ONT_URI + "ClassGroup_no_asserted_instances";    
    
    /**
     * URI for the university class
     */
    public static final String UNIVERSITY_CLASS_URI = EAGLE_I_URI + "ERO_0000065";

    /**
     * URI for property that is used to record the direct rdf:type of a resource when the type 
     * hierarchy is being materialized.
     */
    public static final String DIRECT_TYPE_URI = EAGLE_I_URI + "directType";

    /**
     * URI for the organization
     * TODO would really like to move this to EagleITestOntConstants but it is used for excluding 
     * the organization subtree during certain tests.
     */
    public static final String ORGANIZATION_CLASS_URI = "http://purl.obolibrary.org/obo/OBI_0000245";
    
    /**
     * URI for the laboratory class
     * TODO would really like to move this to EagleITestOntConstants but it is used for generating fake data during execution of production components 
     */
    public static final String LAB_CLASS_URI = EAGLE_I_URI + "ERO_0000001";
    
    /**
     * URI for the core facility class
     * TODO would really like to move this to EagleITestOntConstants but it is used for generating fake data during execution of production components
     */
    public static final String CORE_FACILITY_CLASS_URI = EagleIOntConstants.EAGLE_I_URI + "ERO_0000002";

    /**
     * URI for the core facility class
     * TODO would really like to move this to EagleITestOntConstants but it is used for generating fake data during execution of production components 
     */
    //public static final String RESEARCH_FACILITY_CLASS_URI = EagleIOntConstants.EAGLE_I_URI + "ERO_0000003";

    /**
     * URI for the located_in object property
     */
    public static final String LOCATED_IN_URI = "http://www.obofoundry.org/ro/ro.owl#located_in";

    /**
     * URI for the location_of object property
     */
    public static final String LOCATION_OF_URI = "http://www.obofoundry.org/ro/ro.owl#location_of";
    
    /**
     * URI for the used_by object property
     */
    public static final String USED_BY_URI = "http://purl.obolibrary.org/obo/ERO_0000070";

    /**
     * URI for the service_provided_by property
     */
    public static final String SERVICE_PROVIDED_BY_URI = "http://purl.obolibrary.org/obo/ERO_0000390";
    
}