/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JenaEIInstanceFactoryTest
extends TestCase {
    private static final String EI_INSTRUMENT = "http://purl.obolibrary.org/obo/ERO_0000004";
    private static final String RDFS_URI = "http://www.w3.org/2000/01/rdf-schema#";
    private static final Log logger = LogFactory.getLog(JenaEIInstanceFactoryTest.class);
    private static final String instanceListFileName = "Boyer Core Laboratory.rdf";
    private static final String singleInstanceFileName = "AlaskaEIInstanceTest.rdf";
    private static final String sparqlFilename = "sparql-results.xml";
    private static final String embeddedInstanceFile = "antibody-test-instance.rdf";
    private static final EIURI testURIForSingleInstance = EIURI.create((String)"http://dev.alaska.eagle-i.net/i/INSTANCE_6ceac5c4-cb64-40f3-8451-d877d936430d");
    private static final EIURI EI_INSTRUMENT_URI = EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000004");
    private static final String EI_INSTRUMENT_LABEL = "Instrument";
    private static final String RDFS_LABEL = "http://www.w3.org/2000/01/rdf-schema#label";
    private JenaEIInstanceFactory instanceFactory;

    protected void setUp() throws Exception {
        InputStream is = ClassLoader.getSystemResource("model-jena-test.properties").openStream();
        System.getProperties().load(is);
        is.close();
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"jena-model-config.xml"});
        this.instanceFactory = (JenaEIInstanceFactory)context.getBean(JenaEIInstanceFactory.class);
    }

    public void testCreateEIURIModel() {
    }

    public void testCreateModel() {
        Model model = this.createModelFromFile(instanceListFileName);
        List instances = this.instanceFactory.createExtended(model);
        JenaEIInstanceFactoryTest.assertNotNull((Object)instances);
        logger.debug((Object)("Created " + instances.size() + " instances:"));
        JenaEIInstanceFactoryTest.assertEquals((int)7, (int)instances.size());
        for (EIInstance e : instances) {
            JenaEIInstanceFactoryTest.assertNotNull((Object)e);
        }
    }

    @Test
    public void createSingleInstance() {
        Model model = this.createModelFromFile(singleInstanceFileName);
        EIInstance instance = this.instanceFactory.create(testURIForSingleInstance, model);
        JenaEIInstanceFactoryTest.assertNotNull((String)"EIInstanceFactory#create(final EIURI instanceUri, final Model model) failed to create Instance", (Object)instance);
    }

    @Test
    public void testAllPropertiesCorrectlyCreated() {
        Model model = this.createModelFromFile(singleInstanceFileName);
        EIInstance instance = this.instanceFactory.createExtended(testURIForSingleInstance, model);
        int propertyCount = this.countProperties(instance);
        JenaEIInstanceFactoryTest.assertEquals((String)"incorrect number of properties", (int)8, (int)propertyCount);
        EIEntity typeEntity = EIEntity.create((EIURI)EI_INSTRUMENT_URI, (String)EI_INSTRUMENT_LABEL);
        JenaEIInstanceFactoryTest.assertEquals((String)"instance type was not correctly created", (Object)typeEntity, (Object)instance.getInstanceType());
        JenaEIInstanceFactoryTest.assertEquals((String)"instance label was not correctly created", (String)"Actiheart 19", (String)instance.getInstanceLabel());
    }

    private int countProperties(EIInstance instance) {
        int propertyCount = this.getCountfromMap(instance.getReadOnlyResourceProperties());
        propertyCount += this.getCountfromMap(instance.getReadOnlyLiteralProperties());
        propertyCount += this.getCountfromMap(instance.getObjectProperties());
        propertyCount += this.getCountfromMap(instance.getDatatypeProperties());
        propertyCount += this.getCountfromMap(instance.getNonOntologyLiteralProperties());
        return propertyCount += this.getCountfromMap(instance.getNonOntologyResourceProperties());
    }

    @Test
    public void testconverToJenaModel() {
        Model expectedModel = this.createModelFromFile(singleInstanceFileName);
        EIInstance instance = this.instanceFactory.createExtended(testURIForSingleInstance, expectedModel);
        Model modelAfterConvert = this.instanceFactory.convertToJenaModel(instance);
        StmtIterator iter = expectedModel.listStatements();
        while (iter.hasNext()) {
            Statement statement = (Statement)iter.next();
            JenaEIInstanceFactoryTest.assertTrue((boolean)modelAfterConvert.contains(statement));
        }
    }

    @Test
    public void testSerialization() {
        Model expectedModel = this.createModelFromFile(singleInstanceFileName);
        EIInstance instance = this.instanceFactory.createExtended(testURIForSingleInstance, expectedModel);
        String rdfXmlString = this.instanceFactory.serialize(instance, "RDF/XML");
        Model afterSerialize = ModelFactory.createDefaultModel();
        StringReader reader = new StringReader(rdfXmlString);
        afterSerialize.read((Reader)reader, null, "RDF/XML");
        StmtIterator iter = expectedModel.listStatements();
        while (iter.hasNext()) {
            Statement statement = (Statement)iter.next();
            JenaEIInstanceFactoryTest.assertTrue((boolean)afterSerialize.contains(statement));
        }
    }

    @Test
    public void testcreateEmptyInstance() {
        EIEntity typeEntity = EIEntity.create((EIURI)EI_INSTRUMENT_URI, (String)EI_INSTRUMENT_LABEL);
        EIInstance instance = this.instanceFactory.createEmpty(EI_INSTRUMENT_URI, typeEntity);
        int propertyCount = this.countProperties(instance);
        JenaEIInstanceFactoryTest.assertEquals((String)"incorrect number of properties", (int)0, (int)propertyCount);
        JenaEIInstanceFactoryTest.assertEquals((String)"Instance type is not correctly created", (Object)typeEntity, (Object)instance.getInstanceType());
        JenaEIInstanceFactoryTest.assertEquals((String)"Instance label is not correctly created", (String)EI_INSTRUMENT_LABEL, (String)instance.getInstanceLabel());
    }

    @Test
    public void testInstanceWithEmbeddedInstances() {
        Model model = this.createModelFromFile(embeddedInstanceFile);
        EIURI mainInstanceUri = EIURI.create((String)"http://demo.dartmouth.eagle-i.net/i/0000012d-f10f-f645-d74d-1c6480000000");
        EIInstance instance = this.instanceFactory.createExtended(mainInstanceUri, model);
        EIEntity embeddedProp = EIEntity.create((EIURI)EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000557"), (String)"antibody immunogen");
        EIEntity nonEmbeddedProp = EIEntity.create((EIURI)EIURI.create((String)"http://www.obofoundry.org/ro/ro.owl#located_in"), (String)"");
        JenaEIInstanceFactoryTest.assertNotNull((String)"Instance should not be null", (Object)instance);
        JenaEIInstanceFactoryTest.assertTrue((String)"Instance should not be null instance", (!EIInstance.NULL_INSTANCE.equals(instance) ? 1 : 0) != 0);
        JenaEIInstanceFactoryTest.assertTrue((String)"Instance should have embedded instances flag", (boolean)instance.hasEmbeddedInstances());
        JenaEIInstanceFactoryTest.assertFalse((String)"Instance should not be embedded", (boolean)instance.isEmbeddedInstance());
        JenaEIInstanceFactoryTest.assertTrue((String)"Instance should be extended", (boolean)instance.isExtendedInstance());
        JenaEIInstanceFactoryTest.assertEquals((String)"Number of properties is incorrect", (int)9, (int)this.countProperties(instance));
        List embeddedInstances = instance.getEmbeddedInstanceList();
        JenaEIInstanceFactoryTest.assertEquals((String)"List of embedded instances should contain two elements", (int)2, (int)embeddedInstances.size());
        EIInstance embedded1 = (EIInstance)embeddedInstances.get(0);
        EIInstance embedded2 = (EIInstance)embeddedInstances.get(1);
        JenaEIInstanceFactoryTest.assertNotNull((String)"Instance should not be null", (Object)embedded1);
        JenaEIInstanceFactoryTest.assertNotNull((String)"Instance should not be null", (Object)embedded2);
        JenaEIInstanceFactoryTest.assertTrue((String)"Instance should not be null instance", (!EIInstance.NULL_INSTANCE.equals(embedded1) ? 1 : 0) != 0);
        JenaEIInstanceFactoryTest.assertTrue((String)"Instance should not be null instance", (!EIInstance.NULL_INSTANCE.equals(embedded2) ? 1 : 0) != 0);
        JenaEIInstanceFactoryTest.assertTrue((String)"Instance should be embedded", (boolean)embedded1.isEmbeddedInstance());
        JenaEIInstanceFactoryTest.assertTrue((String)"Instance should be embedded", (boolean)embedded2.isEmbeddedInstance());
        JenaEIInstanceFactoryTest.assertFalse((String)"Instance should not have embedded instances", (boolean)embedded1.hasEmbeddedInstances());
        JenaEIInstanceFactoryTest.assertFalse((String)"Instance should not have embedded instances", (boolean)embedded2.hasEmbeddedInstances());
        JenaEIInstanceFactoryTest.assertFalse((String)"Instance should not be extended", (boolean)embedded1.isExtendedInstance());
        JenaEIInstanceFactoryTest.assertFalse((String)"Instance should not be extended", (boolean)embedded2.isExtendedInstance());
        Set valuesOfImmunogenProperty = instance.getObjectProperty(embeddedProp);
        JenaEIInstanceFactoryTest.assertEquals((String)"incorrect number of property values", (int)2, (int)valuesOfImmunogenProperty.size());
        JenaEIInstanceFactoryTest.assertTrue((String)"Values should contain embedded instance entity", (boolean)valuesOfImmunogenProperty.contains(embedded1.getEntity()));
        JenaEIInstanceFactoryTest.assertTrue((String)"Values should contain embedded instance entity", (boolean)valuesOfImmunogenProperty.contains(embedded2.getEntity()));
        EIInstance instanceFromSerialized = this.instanceFactory.createExtended(mainInstanceUri, this.instanceFactory.serialize(instance, "RDF/XML"), "RDF/XML");
        JenaEIInstanceFactoryTest.assertNotNull((String)"Instance should not be null", (Object)instanceFromSerialized);
        JenaEIInstanceFactoryTest.assertTrue((String)"Instance should not be null instance", (!EIInstance.NULL_INSTANCE.equals(instanceFromSerialized) ? 1 : 0) != 0);
        JenaEIInstanceFactoryTest.assertTrue((String)"Instance should have embedded instances flag", (boolean)instanceFromSerialized.hasEmbeddedInstances());
        JenaEIInstanceFactoryTest.assertFalse((String)"Instance should not be embedded", (boolean)instanceFromSerialized.isEmbeddedInstance());
        JenaEIInstanceFactoryTest.assertTrue((String)"Instance should be extended", (boolean)instanceFromSerialized.isExtendedInstance());
        JenaEIInstanceFactoryTest.assertEquals((String)"Number of properties is incorrect", (int)9, (int)this.countProperties(instanceFromSerialized));
        List embeddedInstancesFromSerialized = instance.getEmbeddedInstanceUriList();
        JenaEIInstanceFactoryTest.assertEquals((String)"List of embedded instances should contain two elements", (int)2, (int)embeddedInstancesFromSerialized.size());
        JenaEIInstanceFactoryTest.assertTrue((String)"List of embedded URIs should contain embeddedInstance", (boolean)embeddedInstancesFromSerialized.contains(embedded1.getEntity().getURI()));
        JenaEIInstanceFactoryTest.assertTrue((String)"List of embedded URIs should contain embeddedInstance", (boolean)embeddedInstancesFromSerialized.contains(embedded2.getEntity().getURI()));
        JenaEIInstanceFactoryTest.assertTrue((String)"Property pointing to embedded should indicate so", (boolean)instance.isPropertyValueAnEmbeddedInstance(embeddedProp));
        JenaEIInstanceFactoryTest.assertFalse((String)"Property pointing to non embedded shouldn't return true", (boolean)instance.isPropertyValueAnEmbeddedInstance(nonEmbeddedProp));
        instance.removeEmbeddedInstance(embedded1.getEntity());
        instance.removeEmbeddedInstance(embedded2.getEntity());
        JenaEIInstanceFactoryTest.assertFalse((String)"Instance should not have embedded after removing them", (boolean)instance.hasEmbeddedInstances());
        JenaEIInstanceFactoryTest.assertFalse((String)"Property should not indicate embedded object any more", (boolean)instance.isPropertyValueAnEmbeddedInstance(embeddedProp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model createModelFromFile(String fileName) {
        Model model = ModelFactory.createDefaultModel();
        InputStream is = null;
        try {
            is = ClassLoader.getSystemResourceAsStream(fileName);
            logger.debug((Object)("Opening file: " + fileName));
            model.read(is, null);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        return model;
    }

    private int getCountfromMap(Map map) {
        if (map != null) {
            return map.size();
        }
        return 0;
    }
}

