/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.model.jena.LogItem;

public class NonResourceVisitor
implements EIOntModel.Visitor {
    protected static final Log logger = LogFactory.getLog(NonResourceVisitor.class);
    private JenaEIOntModel model;
    public Set<EIClass> setNonResource;
    int count;
    public ArrayList<LogItem> listMessages = new ArrayList();
    public ArrayList<LogItem> listInfos = new ArrayList();
    public ArrayList<LogItem> listWarnings = new ArrayList();
    public ArrayList<LogItem> listErrors = new ArrayList();

    public NonResourceVisitor(EIOntModel model) {
        this.model = (JenaEIOntModel)model;
        this.setNonResource = new HashSet<EIClass>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String traversalComplete() {
        String string;
        OutputStreamWriter fw = null;
        try {
            LogItem item;
            String msg;
            logger.info((Object)("Writing non-resource class file.  Num classes: " + this.setNonResource.size()));
            File dir = NonResourceVisitor.ensureOutputDirectory("target/output");
            File f = new File(dir, "rootNonResourceList.txt");
            if (f.exists() && !f.delete()) {
                String string2 = "Unable to delete: " + f.getAbsolutePath();
                return string2;
            }
            fw = new FileWriter(f);
            for (EIClass c : this.setNonResource) {
                logger.info((Object)("  " + c.getEntity()));
                fw.write(c.getEntity().getURI().toString());
                fw.write(44);
            }
            for (EIClass c : this.setNonResource) {
                if (this.model.getNonResourceBaseClasses().contains(c)) continue;
                msg = "A non-resource class was found in the ontology that is not in rootNonResourceList.txt:  " + c.toString() + "\r\nIt needs to be added to the resources/rootNonResourceList.txt file.\r\n";
                item = new LogItem(LogItem.Levels.ERROR, c.getEntity().getURI().toString(), c.getEntity().getLabel(), msg);
                this.listMessages.add(item);
                this.listErrors.add(item);
            }
            for (EIClass c : this.model.getNonResourceBaseClasses()) {
                if (this.setNonResource.contains(c)) continue;
                msg = "A class in rootNonResourceList.txt was not identified as a non-resource class in this ontology scan:  " + c.toString() + "\r\nIt needs to be removed from the resources/rootNonResourceList.txt file.\r\n";
                item = new LogItem(LogItem.Levels.ERROR, c.getEntity().getURI().toString(), c.getEntity().getLabel(), msg);
                this.listMessages.add(item);
                this.listErrors.add(item);
            }
            StringBuilder buf = null;
            if (this.listErrors.size() > 0) {
                logger.info((Object)("Non-resource class scan found " + this.listErrors.size() + " errors."));
                buf = new StringBuilder();
                buf.append("Non-resource class scan found " + this.listErrors.size() + " errors\n");
                for (LogItem error : this.listErrors) {
                    buf.append(error.uri + " : " + error.label + " : " + error.msg + "\n");
                }
            }
            string = buf != null ? buf.toString() : null;
        }
        catch (IOException e) {
            logger.error((Object)e);
            String string3 = e.getMessage();
            return string3;
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {}
            }
        }
        return string;
    }

    public void visit(EIClass c, Deque<String> stack) {
        if (this.count % 20 == 0) {
            logger.info((Object)(this.count + " classes have been checked.  non-resource classes: " + this.setNonResource.size()));
        }
        ++this.count;
        if (!c.isEagleIResource()) {
            this.addNonResourceClass(c);
        }
    }

    public void visit(EIProperty p, Deque<String> stack) {
    }

    private void addNonResourceClass(EIClass c) {
        HashSet<EIClass> remove = new HashSet<EIClass>();
        OntClass ontClass = this.model.getOntologyClass(c.getEntity().getURI().toString());
        for (EIClass member : this.setNonResource) {
            OntClass memberOntClass = this.model.getOntologyClass(member.getEntity().getURI().toString());
            if (memberOntClass.hasSubClass((Resource)ontClass)) {
                return;
            }
            if (!ontClass.hasSubClass((Resource)memberOntClass)) continue;
            remove.add(member);
            logger.debug((Object)(c.getEntity().getLabel() + ":  addNonResourceClass: REMOVED:" + member.getEntity().getLabel()));
        }
        this.setNonResource.removeAll(remove);
        this.setNonResource.add(c);
        logger.debug((Object)(c.getEntity().getLabel() + ":  addNonResourceClass: ADDED:"));
    }

    public static File ensureOutputDirectory(String outputPath) throws IOException {
        if (outputPath == null || outputPath.length() == 0) {
            logger.error((Object)"Empty or null output path");
            return null;
        }
        File outputDir = new File(outputPath);
        logger.info((Object)("Generating test data to directory: " + outputDir.getAbsolutePath()));
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            logger.error((Object)("Failed to create output directory " + outputDir.getAbsolutePath()));
            return null;
        }
        return outputDir;
    }
}

