/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import org.eaglei.model.EIURI;
import org.eaglei.model.jena.BulkCurationQueryBuilder;
import org.eaglei.model.jena.QueryBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BulkCurationQueryBuilderTest {
    private static QueryBuilder bulkQueryBuilder;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        bulkQueryBuilder = BulkCurationQueryBuilder.getInstance();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testDiagnoseQueryWhenObjectIsLiteral() {
        String query = bulkQueryBuilder.diagnoseQuery(EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000005"), EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000045"), "Different fees apply to BIDMC external personnel.", QueryBuilder.RDFobjectType.objectIsLiteral);
        Assert.assertEquals((Object)"PREFIX ei-dt: <http://eagle-i.org/ont/datatools/1.0/> SELECT DISTINCT ?r_subject ?r_type ?r_label WHERE { ?r_subject a <http://purl.obolibrary.org/obo/ERO_0000005> . ?r_subject <http://www.w3.org/2000/01/rdf-schema#label> ?r_label . ?r_subject <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?r_type . ?r_subject <http://purl.obolibrary.org/obo/ERO_0000045> \"Different fees apply to BIDMC external personnel.\" . }", (Object)query);
    }

    @Test
    public void testDiagnoseQueryWhenObjectIsResource() {
        String query = bulkQueryBuilder.diagnoseQuery(EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000005"), EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000390"), "http://qa.harvard.eagle-i.net/i/0000012a-2519-87fe-5617-794280000000", QueryBuilder.RDFobjectType.objectIsResource);
        Assert.assertEquals((Object)"PREFIX ei-dt: <http://eagle-i.org/ont/datatools/1.0/> SELECT DISTINCT ?r_subject ?r_type ?r_label WHERE { ?r_subject a <http://purl.obolibrary.org/obo/ERO_0000005> . ?r_subject <http://www.w3.org/2000/01/rdf-schema#label> ?r_label . ?r_subject <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?r_type . ?r_subject <http://purl.obolibrary.org/obo/ERO_0000390> <http://qa.harvard.eagle-i.net/i/0000012a-2519-87fe-5617-794280000000> . }", (Object)query);
    }

    @Test
    public void testGetDelteQueryWhenObjectIsLiteral() {
    }

    @Test
    public void testGetDelteQueryWhenObjectIsResource() {
    }

    @Test
    public void testGetObjectLiteralReplaceQuery() {
    }

    @Test
    public void testGetObjectResourceReplaceQuery() {
    }

    @Test
    public void testGetPropertyReplaceQueryWhenObjectIsLiteral() {
    }

    @Test
    public void testGetPropertyReplaceQueryWhenObjectIsResource() {
    }
}

