/**
 * The eagle-i consortium
 * Harvard University
 * Apr 7, 2011
 */
package org.eaglei.model.jena;

import static org.eaglei.model.jena.SPARQLConstants.STATE_VARIABLE;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

import com.hp.hpl.jena.query.QuerySolution;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public class SPARQLResultsUtil {
	public static EIEntity getEntityFromSolution(final QuerySolution solution, final String uriVariable, final String labelVariable) {
		if ( solution.contains( uriVariable ) ) {
			final EIURI uri = EIURI.create( solution.getResource( uriVariable ).getURI() );
			if ( STATE_VARIABLE.equals( uriVariable ) ) {
				return MetadataConstants.getStatusEntity( uri );
			}
			String label = "<none>";
			if ( solution.contains( labelVariable ) ) {
				label = solution.getLiteral( labelVariable ).getString();
			}
			return EIEntity.create( uri, label );
		} else {
			return EIEntity.NULL_ENTITY;
		}
	}

	public static EIURI getUriFromSolution(final QuerySolution solution, final String variable) {
		if ( solution.contains( variable ) ) {
			return EIURI.create( solution.getResource( variable ).getURI() );
		} else {
			return EIURI.NULL_EIURI;
		}
	}

	public static String getStringFromSolution(final QuerySolution solution, final String variable) {
		if ( solution.contains( variable ) ) {
			return solution.getLiteral( variable ).getString();
		} else {
			return "";
		}
	}

	public static boolean getBooleanFromSolution(final QuerySolution solution, final String variable) {
		if ( solution.contains( variable ) ) {
			return solution.getLiteral( variable ).getString().equals( "True" );
			// || solution.getLiteral( variable ).getBoolean(); // TODO: use this once type is fixed
		} else {
			return false;
		}
	}

}
