/*
 * $Id$
 * --------------------------------------------------------------------------------------
 * Copyright (c) VectorC, LLC.  All rights reserved.  http://www.vectorc.com
 */

package org.eaglei.model.webapp.client;

import org.eaglei.model.EIClass;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.CssResource.NotStrict;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class SideBar extends Composite {

    interface SidebarResources extends ClientBundle {
        @NotStrict
        @Source("sidebar.css")
        CssResource css();
    }

    public static class Component extends Composite {
        private final Grid outer = new Grid(2, 1);
        
        public Component(String title, Widget main) {
            this(title);
            setWidget(main);
        }
        
        public Component(String title) {
            outer.setCellPadding(0);
            outer.setCellSpacing(0);
            initWidget(outer);
            setStyleName("sidebar-Component");
            
            outer.setText(0, 0, title);
            outer.getCellFormatter().setStyleName(0, 0, "title");      
        }
        
        public void setWidget(Widget main) {
            outer.setWidget(1, 0, main);
            main.setStyleName("body");
        }
    }
    
    private final VerticalPanel outer = new VerticalPanel();
    private ResourceNavigatorComponent compResourceNav;
    private NonResourceNavigatorComponent compNonResourceNav;

    /**
     * 
     */
    public SideBar() {
        GWT.<SidebarResources> create(SidebarResources.class).css().ensureInjected();
        initWidget(outer);
        setStyleName("sidebar");

        outer.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
        
        //HTML first = new HTML("&nbsp;", true), rest = new HTML("&nbsp;", true);
        //first.setStyleName("sidebar-First");
        HTML rest = new HTML("&nbsp;", true);
        rest.setStyleName("sidebar-Rest");
        //first.setHeight("100%");
        rest.setHeight("100%");

        //outer.add(first);
        outer.add(rest);
        //first.setHeight("100%");
        //outer.setCellHeight(first, "100%");
        outer.setCellWidth(rest, "100%");
        
        init();
    }
    
    private void init() {
        compResourceNav = new ResourceNavigatorComponent();
        insertLast(compResourceNav);
        compNonResourceNav = new NonResourceNavigatorComponent();
        insertLast(compNonResourceNav);
    }

    /**
     * 
    public Component addComponent(String title, Widget main) {
        Component comp = new Component(title, main);
        addComponent(comp);
        return comp;
    }
     */

    /**
     * 
     */
    public void insertComponent(Component comp, int index) {
        // Insert before rest widget
        assert(index < outer.getWidgetCount() - 1);
    	outer.insert(comp, index);
    }
    
    public void insertLast(Component comp) {
        outer.insert(comp, outer.getWidgetCount() - 1);
    }

    public void setClass(EIClass clazz) {
        compResourceNav.setClass(clazz);
        compNonResourceNav.setClass(clazz);
    }

}
