package org.eaglei.model.webapp.client;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.model.webapp.client.searchbar.SearchBar;
import org.eaglei.model.webapp.client.searchbar.TermSearchRequest;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ClientBundle.Source;
import com.google.gwt.resources.client.CssResource.NotStrict;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootLayoutPanel;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class Glossary implements EntryPoint {
	
    interface GlossaryResources extends ClientBundle {
        @NotStrict
        @Source("glossary.css")
        CssResource css();
    }

    /**
     * The message displayed to the user when the server cannot be reached or
     * returns an error.
     */
    private static final String SERVER_ERROR = "An error occurred while "
            + "attempting to contact the server. Please check your network "
            + "connection and try again.";
    
    interface Binder extends UiBinder<DockLayoutPanel, Glossary> { }
    
    private static final Binder binder = GWT.create(Binder.class);

    /*
    @UiField
    SearchBar searchBar;
    */
    @UiField
    SideBar sideBar;
    @UiField
    MainPanel main;

    private EIClass currentClass = null;

    /**
     * This is the entry point method.
     */
    public void onModuleLoad() {
        GWT.<GlossaryResources> create(GlossaryResources.class).css().ensureInjected();
        
        DockLayoutPanel outer = binder.createAndBindUi(this);
        DOM.getParent(main.getElement()).getStyle().setProperty("width", "100%");


        // Get rid of scrollbars, and clear out the window's built-in margin,
        // because we want to take advantage of the entire client area.
        Window.enableScrolling(false);
        Window.setMargin("0px");
        
        // Add the outer panel to the RootLayoutPanel, so that it will be
        // displayed.
        RootLayoutPanel root = RootLayoutPanel.get();
        root.add(outer);

        History.addValueChangeHandler(new ValueChangeHandler<String>() {
            public void onValueChange(ValueChangeEvent<String> event) {
                String historyToken = event.getValue();
                handleHistoryChanged(historyToken);
            }
        });
        // Show the initial screen.
        String initToken = History.getToken();
        handleHistoryChanged(initToken);
    }

    private void handleHistoryChanged(String strToken) {
        if (strToken == null || strToken.length() == 0) {
            currentClass = null;
            setClass(null);
        } else {
            TermSearchRequest currentRequest = TermSearchRequest.parse(strToken);
            if (currentRequest.getBinding() == null) {
            	setClass(null);
            } else {
            	EIURI uri = currentRequest.getBinding().getType();
                ClientModelManager.INSTANCE.getClass(uri, new ClassCallback() {

					@Override
					public void onSuccess(EIClass result) {
						setClass(result);
					}
					
                }); 
            }
        }
    }
    
    private void setClass(EIClass clazz) {
    	/*
        searchBar.setClass(clazz);
        */
        sideBar.setClass(clazz);
        main.setClass(clazz);
    }

}
