package org.eaglei.model.webapp.client;

import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.NonResourceBaseClassesCallback;
import org.eaglei.model.webapp.client.SideBar.Component;


public class NonResourceNavigatorComponent extends Component {

    private static class NonResourceNavigatorPanel extends AbstractNavigatorPanel {

        @Override
        protected String getAllLinkLabel() {
            return "All Other";
        }

        @Override
        protected void getRootClasses() {
            ClientModelManager.INSTANCE.getNonResourceClasses(new NonResourceBaseClassesCallback() {

                @Override
                public void onSuccess(List<EIClass> result) {
                    setRootClasses(result);
                }
            });
        }
    }
    
    private NonResourceNavigatorPanel p;

    public NonResourceNavigatorComponent() {
        super("Referenced Taxonomies");
        p = new NonResourceNavigatorPanel();
        setWidget(p);
    }

    public void setClass(EIClass clazz) {
    	if (clazz != null && clazz.isEagleIResource()) {
    		p.setClass(null);
    	} else {
    		p.setClass(clazz);
    	}
    }
    
}
