package org.eaglei.model.webapp.client;

import java.util.ArrayList;
import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassDefinitionCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.LabelsCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.PropertyCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.SuperClassesCallback;
import org.eaglei.model.webapp.client.searchbar.TermSearchRequest;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class TermComment extends Composite {
    
    private class TermCommentForm extends CommentForm {
        TermCommentForm() {
            super("[Term Comment]  ");
        }

        @Override
        protected void submitComment(Comment comment) {
            commentService.submitTermComment(comment, new AsyncCallback<String>() {
                
                @Override
                public void onSuccess(String result) {
                    setSending(false);
                    onCancel();
                    Window.alert("Your term comment was successfully submitted.");
                }
                
                @Override
                public void onFailure(Throwable caught) {
                    setSending(false);
                    Window.alert("Error submitting your term comment.");
                }
            });
            setSending(true);
        }

        @Override
        protected void onCancel() {
            open.setVisible(true);
            commentTitle.setVisible(false);
            comment.setVisible(false);
            setSending(false);
        }
    }

    private final VerticalPanel outer = new VerticalPanel();
    
    private EIClass currentClass;
    
    private Label title;
    private Label ancestors;
    private Grid definitionTable;
    private Label altLabels;
    private Label definition;
    private HorizontalPanel loadingPropertiesPanel;
    private Grid propertyTable;
    private Label commentTitle;
    private Anchor open;
    private CommentForm comment;

    public TermComment() {
        initWidget(outer);

		setStyleName("MainComponent");
		
		HorizontalPanel titlePanel = new HorizontalPanel();
        outer.add(titlePanel);
        titlePanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
        title = new Label();
        titlePanel.add(title);
        title.setStyleName("title");
        ancestors = new Label();
        titlePanel.add(ancestors);
        ancestors.setStyleName("ancestors");
        
        definitionTable = new Grid(2, 2);
        outer.add(definitionTable);
        
        definitionTable.setText(0, 0, "Synonyms:");
        altLabels = new Label();
        definitionTable.setWidget(0, 1, altLabels);
        altLabels.setStyleName("altLabels");
        
        definitionTable.setText(1, 0, "Definition:");
        definition = new Label();
        definitionTable.setWidget(1, 1, definition);
        definition.setStyleName("definition");
        
        definitionTable.getRowFormatter().setVerticalAlign(0, HasVerticalAlignment.ALIGN_TOP);
        definitionTable.getRowFormatter().setVerticalAlign(1, HasVerticalAlignment.ALIGN_TOP);
        
        loadingPropertiesPanel = new HorizontalPanel();
        loadingPropertiesPanel.add(new Image("images/loading.gif"));
        loadingPropertiesPanel.add(new Label("Getting properties..."));
        outer.add(loadingPropertiesPanel);
        loadingPropertiesPanel.setStyleName("propertyTable");
        
        propertyTable = new Grid(0, 2);
        outer.add(propertyTable);
        propertyTable.setStyleName("propertyTable");
        open = new Anchor("Submit a Term Comment >>");
        outer.add(open);
        commentTitle = new Label("Term Comment");
        outer.add(commentTitle);
        commentTitle.setStyleName("commentTitle");
        comment = new TermCommentForm();
        outer.add(comment);
        
        open.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				open.setVisible(false);
				commentTitle.setVisible(true);
				comment.setVisible(true);
			}
		});
		propertyTable.setVisible(false);
		commentTitle.setVisible(false);
        comment.setVisible(false);
		setVisible(false);

    }
    
    public void setClass(final EIClass clazz) {
    	if (clazz == currentClass) {
    		return;
    	}
    	currentClass = clazz;
    	if (clazz == null) {
    		setVisible(false);
    	} else {
    		title.setText(clazz.getEntity().getLabel());
    		ancestors.setText("");
            ClientModelManager.INSTANCE.getSuperClasses(clazz, new SuperClassesCallback() {

                @Override
                public void onSuccess(EIClass result) {
                    if (!result.equals(currentClass)) {
                        return;
                    }
                	ancestors.setText(CommentForm.generateClassLabel(result));
                }
            });
            setDefinition(clazz);
            setAltLabels(clazz);
    		setProperties(clazz);
    		comment.setResource(clazz);
    		setVisible(true);
    	}
        comment.setSending(false);
    }
    
    private void setDefinition(EIClass clazz) {
		if (clazz.getDefinition() != null) {
			definition.setText(clazz.getDefinition());
		} else {
			final EIClass reqClass = clazz;
            final ArrayList<EIClass> listNoDefClasses = new ArrayList<EIClass>();
            listNoDefClasses.add(clazz);
            ClientModelManager.INSTANCE.getClassDefinitions(listNoDefClasses, new ClassDefinitionCallback() {

				@Override
				public void onSuccess(List<EIClass> result) {
					if (reqClass.equals(result.get(0))) {
						definition.setText(result.get(0).getDefinition());
					}
				}
            });
    		open.setVisible(true);
			commentTitle.setVisible(false);
    		comment.setVisible(false);
		}   
    }
    
    private void setAltLabels(EIClass clazz) {
        definitionTable.getRowFormatter().setVisible(0, false);
        if (clazz != null) {
            final EIURI reqURI = clazz.getEntity().getURI();
            ClientModelManager.INSTANCE.getLabels(reqURI, new LabelsCallback() {
    
                @Override
                public void onSuccess(EIURI uri, List<String> result) {
                    if (! uri.equals(reqURI)) {
                        return;
                    }
                    if (result.size() < 2) {
                        return;
                    }
                    StringBuilder buf = new StringBuilder();
                    // Skip the first term, as it should be the entity label.
                    int i=1;
                    for (; i<result.size()-1; i++) {
                        buf.append(result.get(i));
                        buf.append(", ");
                    }
                    if (i < result.size()) {
                        buf.append(result.get(i));
                    }
                    altLabels.setText(buf.toString());
                    definitionTable.getRowFormatter().setVisible(0, true);
                }
            });
        }
    }
    
    private void setProperties(EIClass clazz) {
        if (clazz.hasProperty()) {
            if (clazz.getProperties() != null) {
            	setProperties(clazz.getProperties());
                propertyTable.setVisible(true);
                loadingPropertiesPanel.setVisible(false);
            } else {
                propertyTable.setVisible(false);
                loadingPropertiesPanel.setVisible(true);
                ClientModelManager.INSTANCE.getProperties(clazz, new PropertyCallback() {
    				
    				@Override
    				public void onSuccess(EIClass result) {
                        if (!result.equals(currentClass)) {
                            return;
                        }
    		        	setProperties(result.getProperties());
    		            propertyTable.setVisible(true);
    		            loadingPropertiesPanel.setVisible(false);
    				}
    			});                	
            }   
        } else {
            // TODO display "No properties"?
            propertyTable.setVisible(false);
            loadingPropertiesPanel.setVisible(false);
        }
    }
    
    private void setProperties(List<EIProperty> properties) {
    	propertyTable.resizeRows(properties.size());
    	for(int row=0; row<properties.size(); row++) {
    		EIProperty property = properties.get(row);
    		String name = property.getEntity().getLabel();
    		Widget type = null;
    		if (property instanceof EIObjectProperty) {
    		    List<EIClass> rangeList = ((EIObjectProperty) property).getRangeList();
    		    if (rangeList != null && rangeList.size() > 0) {
    		        type = new HorizontalPanel();
    		        for (EIClass range : rangeList) {
    	                String typeString = range.getEntity().getLabel();
    	                TermSearchRequest request = new TermSearchRequest();
    	                request.setBinding(new TermSearchRequest.TypeBinding(range.getEntity().getURI()));
    			        Hyperlink rangeLink = new Hyperlink(typeString, request.toURLParams());
    			        rangeLink.setStylePrimaryName("rangeLink");
    			        ((HorizontalPanel) type).add(rangeLink);
    		        }
    		    } else {
    		    	type = new Label("<unknown type>");
    		    }
    		} else if (property instanceof EIDatatypeProperty) {
    			String typeString = ((EIDatatypeProperty) property).getTypeLabel();
    			if (typeString == null) {
    				typeString = "<unknown type>";
    			}
    			type = new Label(typeString);
    		}
    		if (name != null && type != null) {
    			propertyTable.setText(row, 0, name);
    			propertyTable.getCellFormatter().setHorizontalAlignment(row, 0, HasHorizontalAlignment.ALIGN_RIGHT);
    			propertyTable.setWidget(row, 1, type);
    			propertyTable.getCellFormatter().setStyleName(row, 1, "datatype");
    		}
    	}
    }
    
}
