package org.eaglei.model.webapp.client;

import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.TopLevelClassesCallback;
import org.eaglei.model.webapp.client.SideBar.Component;

public class ResourceNavigatorComponent extends Component {

    private static class ResourceNavigatorPanel extends AbstractNavigatorPanel {

        @Override
        protected String getAllLinkLabel() {
            return "All Resources";
        }

        @Override
        protected void getRootClasses() {
            ClientModelManager.INSTANCE.getTopLevelClasses(new TopLevelClassesCallback() {

                @Override
                public void onSuccess(List<EIClass> result) {
                    setRootClasses(result);
                }
            });
        }
    }

    private ResourceNavigatorPanel p;

    public ResourceNavigatorComponent() {
        super("Resource Types");
        p = new ResourceNavigatorPanel();
        setWidget(p);
    }

    public void setClass(EIClass clazz) {
    	if (clazz != null && clazz.isEagleIResource()) {
    		p.setClass(clazz);
    	} else {
    		p.setClass(null);
    	}
    }
    
}
