package org.eaglei.model.webapp.client;

import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.FooterPanel;
import org.eaglei.ui.gwt.TopPanel;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class Glossary implements EntryPoint {
	
    /**
     * This is the entry point method.
     */
    public void onModuleLoad() {
        ApplicationResources.INSTANCE.nineSixtyCss().ensureInjected();
        ApplicationResources.INSTANCE.clientCss().ensureInjected();
        ApplicationResources.INSTANCE.resetCss().ensureInjected();
        ApplicationResources.INSTANCE.advancedCss().ensureInjected();
        ApplicationResources.INSTANCE.globalAuxCss().ensureInjected();
        ApplicationResources.INSTANCE.globalCss().ensureInjected();
        
        final TopPanel topPanel = new TopPanel();
        RootPanel.get("header_container").add(topPanel);

        RootPanel mainSlot = RootPanel.get("main_container");
        if (mainSlot == null) {
            Window.alert("Missing main body element");
            return;
        }
        GlossaryPage mainPanel = new GlossaryPage();
        mainSlot.add(mainPanel);

        RootPanel footerSlot = RootPanel.get("footer_container");
        String version = footerSlot.getElement().getInnerText();
        footerSlot.getElement().setInnerText("");
        final FooterPanel footerPanel = new FooterPanel(version);
        footerSlot.add(footerPanel);
    }

}
