package org.eaglei.model.webapp.server.email;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.webapp.client.Comment;
import org.springframework.mail.MailException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;

public class EmailService {

    protected static final Log logger = LogFactory.getLog(EmailService.class);

    private MailSender mailSender;
    private SimpleMailMessage mailTemplate;

    public EmailService() {
        logger.debug("EmailService constructor");
    }

    public String send(Comment comment) {
        logger.debug(comment.from + "; " + comment.subject + "; " + comment.text);
        SimpleMailMessage msg = new SimpleMailMessage(this.mailTemplate);
        //msg.setFrom(comment.from);
        msg.setSubject(comment.subject);
        StringBuilder buf = new StringBuilder("From: ");
        buf.append(comment.from);
        buf.append("\r\n");
        buf.append("\r\n");
        buf.append(comment.text);
        msg.setText(buf.toString());
        try {
            mailSender.send(msg);
            return "Your comment has been submitted.";
        } catch (MailException ex) {
            throw new RuntimeException(ex);
        }
    }
    
    /**
    * @return the mailMessage
    */
    public SimpleMailMessage getMailTemplate() {
        return mailTemplate;
    }

    /**
    * @param mailMessage the mailMessage to set
    */
    public void setMailTemplate(SimpleMailMessage mailTemplate) {
        this.mailTemplate = mailTemplate;
    }


    /**
     * @return the mailSender
     */
    public MailSender getMailSender() {
        return mailSender;
    }

    /**
     * @param mailSender
     *            the mailSender to set
     */
    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }
}
