package org.eaglei.model.webapp.client.searchbar;

import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.TopLevelClassesCallback;
import org.eaglei.model.webapp.client.Application;
import org.eaglei.suggest.client.AbstractSearchBox.SearchHandler;
import org.eaglei.ui.gwt.search.TermSuggestBox;

import com.google.gwt.user.client.ui.Composite;

public class SearchBar extends Composite {

    //interface MyUiBinder extends UiBinder<Widget, SearchBar> {
    //}

    //private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

    //@UiField
    //ListBox resourceListBox;
    //@UiField
    TermSuggestBox termBox;
    //@UiField
    //Button searchButton;

    // Static list of top-level classes
    private List<EIClass> listTopLevelResourceClasses = null;
    private EIClass currentClass = null;
    // Current list of resources displayed in the resource class list
    // Will either be the list of toplevel classes, or it will 
    // be the superclass heirarchy of some non-toplevel class.
    private List<EIClass> listCurrentResourceClasses = null;

    public SearchBar() {
        termBox = new TermSuggestBox() {
            @Override
            public String getDefaultText() {
                return "Enter Term";
            }
            
        };
        termBox.addStyleName("search_widget");
        termBox.addStyleName("searchbar");
        initWidget(termBox);
        //initWidget(uiBinder.createAndBindUi(this));

        // The first item in the resource list box will always
        // be the All Resources label (null TypeBinding)
        // The rest of the list will change dynamically based
        // on the current type binding.
        //resourceListBox.addItem("All Resources");
        /*
        resourceListBox.addChangeHandler(new ChangeHandler() {

            @Override
            public void onChange(ChangeEvent event) {
                if (resourceListBox.getSelectedIndex() > 0) {
                    // Constrain suggestions to 
                    EIURI type = listResourceClasses.get(resourceListBox.getSelectedIndex() - 1).getEntity().getURI();
                    termBox.setClassId(type);
                } else {
                    termBox.setClassId(null);
                }
            }
            
        });
        */
        ClientModelManager.INSTANCE.getTopLevelClasses(new TopLevelClassesCallback() {

            @Override
            public void onSuccess(List<EIClass> result) {
                listTopLevelResourceClasses = result;
                setClass(currentClass);
            }

        });

        /*
        searchButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                SearchRequest request = getSearchRequest();
                Application.executeSearch(request);
            }
        });
        */
        
        termBox.addSearchHandler(new SearchHandler() {
			
            @Override
            public void performSearch(String query, String uri) {
                if (uri == null) {
                    // could put up a warning
                    return;
                }
                TermSearchRequest.TypeBinding binding = 
                    new TermSearchRequest.TypeBinding(EIURI.create(uri));
                TermSearchRequest request = new TermSearchRequest();
                request.setBinding(binding);
                Application.executeSearch(request);
            }
            
		}, true, true);
        
        termBox.setDefaultText();
    }
    
    /*
    public void setTermSearchRequest(TermSearchRequest request) {
        if (request != null && request.getTerm() != null) {
            termBox.setText(request.getTerm().getQuery());
        } else {
            termBox.setDefaultText();
        }
        setResource(request, currentRequest);
        currentRequest = request;
    }
    
    private void setResource(TermSearchRequest newRequest, TermSearchRequest oldRequest) {
    }
    */
    
    public void setClass(EIClass clazz) {
        if (clazz == null) {
            termBox.setDefaultText();
        } else {
            termBox.setText(clazz.getEntity().getLabel());
        }
    	/*
    	currentClass = clazz;
        if (listTopLevelResourceClasses == null) {
            // If we don't have the list of top-level classes yet,
            // no-op and wait for that response thread to populate
            // the list.
            return;
        }
        
        if (clazz == null) {
            // No type binding, display the list of top-level resources
            // select All Resources
            addTopLevelResourceList();
            resourceListBox.setSelectedIndex(0);
        } else {
            final EIURI uriTypeBinding = clazz.getEntity().getURI();
            // There is a type binding, see if it is a top-level
            int indexListBox = 1; // skip All Resources index
            for (EIClass top : listTopLevelResourceClasses) {
                if (top.getEntity().getURI().equals(uriTypeBinding)) {
                    addTopLevelResourceList();
                    resourceListBox.setSelectedIndex(indexListBox);
                    return;
                }
                indexListBox++;
            }
            
            // Not a toplevel, compute the superclass heirarchy
            ClientModelManager.INSTANCE.getSuperClasses(uriTypeBinding, new SuperClassesCallback() {
                
                @Override
                public void onSuccess(EIClass result) {
                    addSuperClassResourceList(result);
                    resourceListBox.setSelectedIndex(resourceListBox.getItemCount()-1);
                }
            });
        }
        */
    }
    
    /*
    private void addTopLevelResourceList() {
        if (listCurrentResourceClasses != listTopLevelResourceClasses) {
            // Clear any previous items
            // be sure to not remove All Resources
            for (int i=resourceListBox.getItemCount()-1; i>0; i--) {
                resourceListBox.removeItem(i);
            }
            for (EIClass rclass : listTopLevelResourceClasses) {
                resourceListBox.addItem(rclass.getEntity().getLabel());
            }
            listCurrentResourceClasses = listTopLevelResourceClasses;
        }
    }
    
    private void addSuperClassResourceList(EIClass rClass) {
        // Clear any previous items
        // be sure to not remove All Resources
        for (int i=resourceListBox.getItemCount()-1; i>0; i--) {
            resourceListBox.removeItem(i);
        }
        // Compute ancestor list
        ArrayList<EIClass> listAncestors = new ArrayList<EIClass>();
        EIClass parent = rClass.getSuperClass();
        while (parent != null) {
            listAncestors.add(parent);
            parent = parent.getSuperClass();
        }
        // Reverse the list for display order
        listCurrentResourceClasses = new ArrayList<EIClass>(listAncestors.size()+1);
        for (int i = listAncestors.size() - 1; i >= 0; i--) {
            resourceListBox.addItem(listAncestors.get(i).getEntity().getLabel());
            listCurrentResourceClasses.add(listAncestors.get(i));
        }
        // The class
        resourceListBox.addItem(rClass.getEntity().getLabel());
        listCurrentResourceClasses.add(rClass);
    }
    */
    
    private TermSearchRequest getTermSearchRequest() {
        TermSearchRequest request = new TermSearchRequest();
        
        String query = termBox.getText();
        if (query != null) {
            query.trim();
        }
        if (query != null && query.length() > 0) {
            TermSearchRequest.Term term = new TermSearchRequest.Term(query);
            request.setTerm(term);
        }
           
        /*
        if (resourceListBox.getSelectedIndex() > 0) {
            EIURI type = listCurrentResourceClasses.get(resourceListBox.getSelectedIndex() - 1).getEntity().getURI();
            TermSearchRequest.TypeBinding binding = new TermSearchRequest.TypeBinding(type);
            request.setBinding(binding);
        }
        */
        
        return request;
    }

}
