/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.webapp.server.email;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.webapp.client.Comment;
import org.springframework.mail.MailException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;

public class EmailService {
    protected static final Log logger = LogFactory.getLog(EmailService.class);
    private MailSender mailSender;
    private SimpleMailMessage mailTemplate;

    public EmailService() {
        logger.debug((Object)"EmailService constructor");
    }

    public String send(Comment comment) {
        logger.debug((Object)(comment.from + "; " + comment.subject + "; " + comment.text));
        SimpleMailMessage msg = new SimpleMailMessage(this.mailTemplate);
        msg.setSubject(comment.subject);
        StringBuilder buf = new StringBuilder("From: ");
        buf.append(comment.from);
        buf.append("\r\n");
        buf.append("\r\n");
        buf.append(comment.text);
        msg.setText(buf.toString());
        try {
            this.mailSender.send(msg);
            return "Your comment has been submitted.";
        }
        catch (MailException ex) {
            throw new RuntimeException(ex);
        }
    }

    public SimpleMailMessage getMailTemplate() {
        return this.mailTemplate;
    }

    public void setMailTemplate(SimpleMailMessage mailTemplate) {
        this.mailTemplate = mailTemplate;
    }

    public MailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }
}

