package org.eaglei.model.webapp.client;

import java.util.ArrayList;

import org.eaglei.model.EIClass;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ModelService;
import org.eaglei.model.gwt.rpc.ModelServiceAsync;
import org.eaglei.model.gwt.rpc.ClientModelManager.SuperClassesCallback;
import org.eaglei.model.webapp.client.SideBar.SidebarResources;
import org.eaglei.model.webapp.client.rpc.CommentService;
import org.eaglei.model.webapp.client.rpc.CommentServiceAsync;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ClientBundle.Source;
import com.google.gwt.resources.client.CssResource.NotStrict;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.FlexTable.FlexCellFormatter;

public abstract class CommentForm extends Composite {
    
    private static final String FROM_ADDRESS_DOMAIN = "@eaglei.org";
    protected static final CommentServiceAsync commentService = GWT.create(CommentService.class);
	
	interface Listener {
		void onCancel();
	}
	
	private FlexTable outer;
	private TextBox username;
	private TextArea commentText;
	private HorizontalPanel sendingPanel;
	private Button submitButton;
	private Button cancelButton;
	private String subjectPrefix;
	private Label subjectLabel;
	
	public CommentForm(String subjectPrefix) {
        this.subjectPrefix = subjectPrefix;
        
		outer = new FlexTable();
		initWidget(outer);
		outer.setStyleName("CommentForm");
		outer.setWidth("100%");
		
		FlexCellFormatter formatter = outer.getFlexCellFormatter();
		
		Label l = new Label("From");
		l.setStyleName("label");
		outer.setWidget(0, 0, l);
		username = new TextBox();
		outer.setWidget(0, 1, username);
		username.setWidth("120px");
		outer.setWidget(0, 2, new Label(FROM_ADDRESS_DOMAIN));
		formatter.setWidth(0, 2, "100%");
		
		l = new Label("Subject");
		l.setStyleName("label");
		outer.setWidget(1, 0, l);
		subjectLabel =  new Label();
		outer.setWidget(1, 1, subjectLabel);
		formatter.setColSpan(1, 1, 2);
		
		l = new Label("Comment");
		l.setStyleName("label");
		outer.setWidget(2, 0, l);
		commentText = new TextArea();
		outer.setWidget(3, 0, commentText);
		commentText.setVisibleLines(8);
		commentText.setWidth("100%");
		formatter.setColSpan(3, 0, 3);
		
		sendingPanel = new HorizontalPanel();
		sendingPanel.add(new Image("images/loading.gif"));
		sendingPanel.add(new Label("Sending..."));
		outer.setWidget(4, 0, sendingPanel);
		formatter.setColSpan(4, 0, 3);
		
		submitButton = new Button("Submit");
		outer.setWidget(5, 0, submitButton);
		cancelButton = new Button("Cancel");
		outer.setWidget(5, 1, cancelButton);
		
        cancelButton.addClickHandler(new ClickHandler() {
            
            @Override
            public void onClick(ClickEvent event) {
                onCancel();
            }
        });
        submitButton.addClickHandler(new ClickHandler() {
            
            @Override
            public void onClick(ClickEvent event) {
                Comment comment = new Comment();
                comment.from = username.getText().trim();
                if (comment.from.length() == 0) {
                    Window.alert("Please enter your eagle-i.org username");
                    return;
                }
                comment.from += FROM_ADDRESS_DOMAIN;
                comment.subject = subjectLabel.getText();
                comment.text = commentText.getText().trim();
                if (comment.text.length() == 0) {
                    Window.alert("Please enter a comment");
                    return;
                }
                submitComment(comment);
            }
        });
        
        setSending(false);
	}
	
	protected abstract void onCancel();
	
	protected abstract void submitComment(Comment comment);
	
	public void setSending(boolean visible) {
	    sendingPanel.setVisible(visible);
	}

	public void setResource(EIClass c) {
		if (c == null) {
			subjectLabel.setText(subjectPrefix + "<none>");
			return;
		}
		subjectLabel.setText("");
        ClientModelManager.INSTANCE.getSuperClasses(c, new SuperClassesCallback() {

            @Override
            public void onSuccess(EIClass result) {
                subjectLabel.setText(subjectPrefix + result.getEntity().getLabel() + "  " + generateClassLabel(result));
            }
        });
	}
	
	/**
	 *  MUST be called inside a ClientModelManager.INSTANCE.getSuperClasses callback.
	 *  
	 * @param c
	 * @return
	 */
	public static String generateClassLabel(EIClass c) {
        ArrayList<EIClass> listAncestors = new ArrayList<EIClass>();
        EIClass parent = c.getSuperClass();
        while (parent != null) {
            listAncestors.add(parent);
            parent = parent.getSuperClass();
        }
        StringBuilder buf = new StringBuilder();
        if (listAncestors.size() > 0) {
        	buf.append("(");
            for (int i = listAncestors.size() - 1; i >= 0; i--) {
            	EIClass a = listAncestors.get(i);
            	buf.append(a.getEntity().getLabel());
            	if (i != 0) {
            		buf.append(" | ");
            	}
            }
        	buf.append(")");
        }
        return buf.toString();
	}
}
