package org.eaglei.model.webapp.client;

import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntConstants;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassesInGroupCallback;
import org.eaglei.model.webapp.client.SideBar.Component;


public class EmbeddedNavigatorComponent extends Component {

    private static class EmbeddedNavigatorPanel extends AbstractNavigatorPanel {

        @Override
        protected String getAllLinkLabel() {
            return "All Embedded Types";
        }
        
    }
    
    private EmbeddedNavigatorPanel p;

    public EmbeddedNavigatorComponent() {
        super("Embedded Types");
        p = new EmbeddedNavigatorPanel();
        setWidget(p);
        ClientModelManager.INSTANCE.getClassesInGroup(EIOntConstants.CG_EMBEDDED_CLASS, new ClassesInGroupCallback() {

            @Override
            public void onSuccess(List<EIClass> result) {
                p.setRootClasses(result);
            }
        });
    }

    public void setClass(EIClass clazz) {
        p.setClass(clazz);
    }
    
}
