package org.eaglei.model.webapp.client;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.model.webapp.client.searchbar.SearchBar;
import org.eaglei.model.webapp.client.searchbar.TermSearchRequest;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.CssResource.NotStrict;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;

public class GlossaryPage extends Composite {

    interface GlossaryResources extends ClientBundle {
/*        @NotStrict
        @Source("glossary.css")
        CssResource css();*/
    }

    //interface Binder extends UiBinder<DockLayoutPanel, GlossaryPage> { }
    
    //private static final Binder binder = GWT.create(Binder.class);

    //@UiField
    SideBar sideBar;
    //@UiField
    MainPanel main;
    SearchBar searchBar;
    
    private EIClass currentClass = null;
    
    public GlossaryPage() {
//        GWT.<GlossaryResources> create(GlossaryResources.class).css().ensureInjected();
        //DockLayoutPanel outer = binder.createAndBindUi(this);
        VerticalPanel outer = new VerticalPanel();
        //outer.setStyleName("container_12");
        Label instructions = new Label("Enter a term name in the search box below to see list of matches in the eagle-i vocabulary.  Alternatively, browse the term heirarchy using the left sidebar.");
        instructions.setStyleName("instructions");
        outer.add(instructions);
        searchBar = new SearchBar();
        outer.add(searchBar);
        HorizontalPanel body = new HorizontalPanel();
        outer.add(body);
        sideBar = new SideBar();
        body.add(sideBar);
        main = new MainPanel();
        body.add(main);
        initWidget(outer);
        
        DOM.getParent(main.getElement()).getStyle().setProperty("width", "100%");
        History.addValueChangeHandler(new ValueChangeHandler<String>() {
            public void onValueChange(ValueChangeEvent<String> event) {
                String historyToken = event.getValue();
                handleHistoryChanged(historyToken);
            }
        });
        // Show the initial screen.
        String initToken = History.getToken();
        handleHistoryChanged(initToken);
    }

    private void handleHistoryChanged(String strToken) {
        if (strToken == null || strToken.length() == 0) {
            currentClass = null;
            setClass(null);
        } else {
            TermSearchRequest currentRequest = TermSearchRequest.parse(strToken);
            if (currentRequest.getBinding() == null) {
                setClass(null);
            } else {
                EIURI uri = currentRequest.getBinding().getType();
                ClientModelManager.INSTANCE.getClass(uri, new ClassCallback() {

                    @Override
                    public void onSuccess(EIClass result) {
                        setClass(result);
                    }
                    
                }); 
            }
        }
    }
    
    private void setClass(EIClass clazz) {
        searchBar.setClass(clazz);
        sideBar.setClass(clazz);
        main.setClass(clazz);
    }
}
