package org.eaglei.model.webapp.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.EIValueRestriction;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassAnnotationsCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassDefinitionCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.LabelsCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.PropertyCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.PropertyDefinitionCallback;
import org.eaglei.model.gwt.rpc.ClientModelManager.SuperClassesCallback;
import org.eaglei.model.webapp.client.searchbar.TermSearchRequest;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class TermComment extends Composite {
    
    private class TermCommentForm extends CommentForm {
        TermCommentForm() {
            super("[Term Comment]  ");
        }

        @Override
        protected void submitComment(Comment comment) {
            commentService.submitTermComment(comment, new AsyncCallback<String>() {
                
                @Override
                public void onSuccess(String result) {
                    setSending(false);
                    onCancel();
                    Window.alert("Your term comment was successfully submitted.");
                }
                
                @Override
                public void onFailure(Throwable caught) {
                    setSending(false);
                    Window.alert("Error submitting your term comment.");
                }
            });
            setSending(true);
        }

        @Override
        protected void onCancel() {
            open.setVisible(true);
            commentTitle.setVisible(false);
            comment.setVisible(false);
            setSending(false);
        }
    }
    
    private class PropertyClickHandler implements ClickHandler {
        
        private EIProperty property;
        private boolean expanded;
        
        PropertyClickHandler(EIProperty property) {
            this.property = property;
            this.expanded = false;
        }

        @Override
        public void onClick(ClickEvent event) {
            if (expanded) {
                handleCollapse();
            } else {
                handleExpand();
            }
        }
        
        public void handleCollapse() {
            int row = mapPropertyToRow.get(property.getEntity().getURI());
            for (EIURI otherProperty : mapPropertyToRow.keySet()) {
                int otherRow = mapPropertyToRow.get(otherProperty);
                if (otherRow > row) {
                    mapPropertyToRow.put(otherProperty, otherRow-3);
                }
            }
            propertyTable.removeRow(row+1);
            propertyTable.removeRow(row+1);
            propertyTable.removeRow(row+1);
            expanded = false;
        }
        
        public void handleExpand() {
            EIURI uri = property.getEntity().getURI();
            int row = mapPropertyToRow.get(property.getEntity().getURI());
            for (EIURI otherProperty : mapPropertyToRow.keySet()) {
                int otherRow = mapPropertyToRow.get(otherProperty);
                if (otherRow > row) {
                    mapPropertyToRow.put(otherProperty, otherRow+3);
                }
            }
            propertyTable.insertRow(row+1);
            setPropertyDetailRow(row+1, "URI", new Label(uri.toString()));
            
            propertyTable.insertRow(row+1);
            Set<String> annotations = property.getAnnotations();
            if (annotations != null && annotations.size() > 0) {
                StringBuilder buf = new StringBuilder();
                for (String v : annotations) {
                    buf.append(v.substring(v.lastIndexOf('/')+1));
                    buf.append("  ");
                }
                setPropertyDetailRow(row+1, "Annotations", new Label(buf.toString()));
            } else {
                setPropertyDetailRow(row+1, "Annotations", new Label("<none>"));
            }
            
            propertyTable.insertRow(row+1);
            String definition = property.getDefinition();
            if (definition != null) {
                setPropertyDetailRow(row+1, "Definition", new Label(definition));
            } else {
                setPropertyDetailRow(row+1, "Definition", new Label("loading..."));
            }
            
            expanded = true;
        }
        
        private void setPropertyDetailRow(int row, String label, Widget value) {
            propertyTable.setWidget(row, 0, new Label(label));
            propertyTable.getCellFormatter().setHorizontalAlignment(row, 0, HasHorizontalAlignment.ALIGN_RIGHT);
            propertyTable.setWidget(row, 1, value);
            propertyTable.getCellFormatter().setStyleName(row, 1, "datatype");
            propertyTable.getRowFormatter().setStyleName(row, "propertyDescriptionRow");
        }
        
    }

    private final VerticalPanel outer = new VerticalPanel();
    
    private EIClass currentClass;
    
    private Label title;
    private Label ancestors;
    private Grid definitionTable;
    private HorizontalPanel inferredTypePanel;
    private Label altLabels;
    private Label definition;
    private Label annotations;
    private HorizontalPanel loadingPropertiesPanel;
    private Grid propertyTable;
    private Label commentTitle;
    private Anchor open;
    private CommentForm comment;
    
    private Map<EIURI,Integer> mapPropertyToRow = new HashMap<EIURI,Integer>();
    
    public TermComment() {
        SimplePanel wrapper = new SimplePanel();
        wrapper.setStyleName("MainComponent");
        wrapper.setWidget(outer);
        initWidget(wrapper);
        
		HorizontalPanel titlePanel = new HorizontalPanel();
        outer.add(titlePanel);
        titlePanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
        title = new Label();
        titlePanel.add(title);
        title.setStyleName("title");
        ancestors = new Label();
        titlePanel.add(ancestors);
        ancestors.setStyleName("ancestors");
        
        definitionTable = new Grid(5, 2);
        definitionTable.setStyleName("definitionTable");
        outer.add(definitionTable);
        
        Label definitionTableLabel = new Label("Is a:");
        definitionTableLabel.setStyleName("label");
        definitionTable.setWidget(0, 0, definitionTableLabel);
        inferredTypePanel = new HorizontalPanel();
        definitionTable.setWidget(0, 1, inferredTypePanel);
        inferredTypePanel.setStyleName("inferredTypePanel");
        
        definitionTableLabel = new Label("Synonyms:");
        definitionTableLabel.setStyleName("label");
        definitionTable.setWidget(1, 0, definitionTableLabel);
        altLabels = new Label();
        definitionTable.setWidget(1, 1, altLabels);
        altLabels.setStyleName("altLabels");
        
        definitionTableLabel = new Label("Definition:");
        definitionTableLabel.setStyleName("label");
        definitionTable.setWidget(2, 0, definitionTableLabel);
        definition = new Label();
        definitionTable.setWidget(2, 1, definition);
        definition.setStyleName("definition");
        
        definitionTableLabel = new Label("Annotations:");
        definitionTableLabel.setStyleName("label");
        definitionTable.setWidget(3, 0, definitionTableLabel);
        annotations = new Label();
        definitionTable.setWidget(3, 1, annotations);
        
        definitionTableLabel = new Label("Properties:");
        definitionTableLabel.setStyleName("label");
        definitionTable.setWidget(4, 0, definitionTableLabel);
        Label propInstructions = new Label("* indicates a required property");
        definitionTable.setWidget(4, 1, propInstructions);
        propInstructions.setStyleName("propInstructions");
        
        definitionTable.getRowFormatter().setVerticalAlign(0, HasVerticalAlignment.ALIGN_TOP);
        definitionTable.getRowFormatter().setVerticalAlign(1, HasVerticalAlignment.ALIGN_TOP);
        definitionTable.getRowFormatter().setVerticalAlign(2, HasVerticalAlignment.ALIGN_TOP);
        definitionTable.getRowFormatter().setVerticalAlign(3, HasVerticalAlignment.ALIGN_TOP);
        definitionTable.getRowFormatter().setVerticalAlign(4, HasVerticalAlignment.ALIGN_TOP);
        
        loadingPropertiesPanel = new HorizontalPanel();
        loadingPropertiesPanel.add(new Image("images/loading.gif"));
        loadingPropertiesPanel.add(new Label("Getting properties..."));
        outer.add(loadingPropertiesPanel);
        loadingPropertiesPanel.setStyleName("propertyTable");
        
        propertyTable = new Grid(0, 2);
        outer.add(propertyTable);
        propertyTable.setStyleName("propertyTable");
        open = new Anchor("Submit a Term Comment >>");
        outer.add(open);
        commentTitle = new Label("Term Comment");
        outer.add(commentTitle);
        commentTitle.setStyleName("commentTitle");
        comment = new TermCommentForm();
        outer.add(comment);
        
        open.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				open.setVisible(false);
				commentTitle.setVisible(true);
				comment.setVisible(true);
			}
		});
		propertyTable.setVisible(false);
		commentTitle.setVisible(false);
        comment.setVisible(false);
		setVisible(false);

    }
    
    public void setClass(final EIClass clazz) {
    	if (clazz == currentClass) {
    		return;
    	}
    	currentClass = clazz;
    	if (clazz == null) {
    		setVisible(false);
    	} else {
    		title.setText(clazz.getEntity().getLabel());
    		if (clazz.isInferred()) {
    			title.addStyleDependentName("inferred");
    		} else {
    			title.removeStyleDependentName("inferred");
    		}
            definitionTable.getRowFormatter().setVisible(0, false);
            ClientModelManager.INSTANCE.getSuperClasses(clazz, new SuperClassesCallback() {

                @Override
                public void onSuccess(EIClass result) {
                    if (!result.equals(currentClass)) {
                        return;
                    }
                	fillInferredTypePanel(result);
                }
            });
            setDefinition(clazz);
            setAltLabels(clazz);
            setAnnotations(clazz);
    		setProperties(clazz);
    		comment.setResource(clazz);
    		setVisible(true);
    	}
        comment.setSending(false);
    }
    
    private void setDefinition(EIClass clazz) {
		if (clazz.getDefinition() != null) {
			definition.setText(clazz.getDefinition());
		} else {
			final EIClass reqClass = clazz;
            final ArrayList<EIClass> listNoDefClasses = new ArrayList<EIClass>();
            listNoDefClasses.add(clazz);
            ClientModelManager.INSTANCE.getClassDefinitions(listNoDefClasses, new ClassDefinitionCallback() {

				@Override
				public void onSuccess(List<EIClass> result) {
					if (reqClass.equals(result.get(0))) {
						definition.setText(result.get(0).getDefinition());
					}
				}
            });
    		open.setVisible(true);
			commentTitle.setVisible(false);
    		comment.setVisible(false);
		}   
    }
    
    private void setAltLabels(EIClass clazz) {
        definitionTable.getRowFormatter().setVisible(1, false);
        if (clazz != null) {
            final EIURI reqURI = clazz.getEntity().getURI();
            ClientModelManager.INSTANCE.getLabels(reqURI, new LabelsCallback() {
    
                @Override
                public void onSuccess(EIURI uri, List<String> result) {
                    if (! uri.equals(reqURI)) {
                        return;
                    }
                    if (result.size() < 2) {
                        return;
                    }
                    StringBuilder buf = new StringBuilder();
                    // Skip the first term, as it should be the entity label.
                    int i=1;
                    for (; i<result.size()-1; i++) {
                        buf.append(result.get(i));
                        buf.append(", ");
                    }
                    if (i < result.size()) {
                        buf.append(result.get(i));
                    }
                    altLabels.setText(buf.toString());
                    definitionTable.getRowFormatter().setVisible(1, true);
                }
            });
        }
    }
    
    private void setAnnotations(final EIClass clazz) {
        definitionTable.getRowFormatter().setVisible(3, false);
        if (clazz != null) {
            final List<EIClass> classList = new ArrayList<EIClass>(1);
            classList.add(clazz);
            ClientModelManager.INSTANCE.getClassAnnotations(classList, new ClassAnnotationsCallback() {
    
                @Override
                public void onSuccess(List<EIClass> result) {
                    if (! result.get(0).equals(currentClass)) {
                        return;
                    }
                    Set<String> setAnnotations = result.get(0).getAnnotations();
                    if (setAnnotations != null && setAnnotations.size() > 0) {
                        StringBuilder buf = new StringBuilder();
                        for (String v : setAnnotations) {
                            buf.append(v.substring(v.lastIndexOf('/')+1));
                            buf.append("  ");
                        }
                        annotations.setText(buf.toString());
                        definitionTable.getRowFormatter().setVisible(3, true);
                    }
                }
            });
        }
    }
    
    private void setProperties(EIClass clazz) {
        if (clazz.hasProperty()) {
            if (clazz.getProperties() != null) {
            	setProperties(clazz.getProperties());
	            definitionTable.getRowFormatter().setVisible(4, true);
                propertyTable.setVisible(true);
                loadingPropertiesPanel.setVisible(false);
            } else {
	            definitionTable.getRowFormatter().setVisible(4, false);
                propertyTable.setVisible(false);
                loadingPropertiesPanel.setVisible(true);
                ClientModelManager.INSTANCE.getProperties(clazz, new PropertyCallback() {
    				
    				@Override
    				public void onSuccess(EIClass result) {
                        if (!result.equals(currentClass)) {
                            return;
                        }
    		        	setProperties(result.getProperties());
    		            definitionTable.getRowFormatter().setVisible(4, result.getProperties().size() > 0);
    		            propertyTable.setVisible(true);
    		            loadingPropertiesPanel.setVisible(false);
    				}
    			});                	
            }   
        } else {
            // TODO display "No properties"?
            definitionTable.getRowFormatter().setVisible(4, false);
            propertyTable.setVisible(false);
            loadingPropertiesPanel.setVisible(false);
        }
    }
    
    private void setProperties(List<EIProperty> properties) {
        HashMap<EIProperty,UIObject> mapNoDefPropertyToUIObject = new HashMap<EIProperty,UIObject>();
     	propertyTable.resizeRows(0);
     	mapPropertyToRow.clear();
    	for(int row=0; row<properties.size(); row++) {
    		EIProperty property = properties.get(row);
    		String name = property.getEntity().getLabel();
    		Widget type = null;
    		if (property instanceof EIObjectProperty) {
    		    List<EIClass> rangeList = ((EIObjectProperty) property).getRangeList();
    		    if (rangeList != null && rangeList.size() > 0) {
    		        type = new HorizontalPanel();
    		        type.setStyleName("linkPanel");
    		        HashSet<EIURI> setRestrictedClasses = new HashSet<EIURI>();
    		        EIValueRestriction restriction = property.getValueRestriction();
    		        EIClass restrictionClass = null;
                    if (restriction != null) {
                        if (restriction.getEIClass() != null) {
                            restrictionClass = restriction.getEIClass();
                            setRestrictedClasses.add(restrictionClass.getEntity().getURI());
                            addRange((HorizontalPanel) type, true, restrictionClass);
                        }
                    }
    		        for (EIClass range : rangeList) {
    		            if (! range.equals(restrictionClass)) {
    		                addRange((HorizontalPanel) type, false, range);
    		            }
    		        }
    		    } else {
    		    	type = new Label("<unknown type>");
    		    }
    		} else if (property instanceof EIDatatypeProperty) {
    			String typeString = ((EIDatatypeProperty) property).getTypeLabel();
    			if (typeString == null) {
    				typeString = "<unknown type>";
    			}
    			type = new Label(typeString);
    		}
    		
    		// Add the row if we have a name and type.
    		if (name != null && type != null) {
    		    propertyTable.insertRow(propertyTable.getRowCount());
    			Anchor propLabel = new Anchor(name);
    			setPropertyDefinitionTooltip(property, propLabel, mapNoDefPropertyToUIObject);
    			propertyTable.setWidget(row, 0, propLabel);
    			propertyTable.getCellFormatter().setHorizontalAlignment(row, 0, HasHorizontalAlignment.ALIGN_RIGHT);
    			propertyTable.setWidget(row, 1, type);
    			propertyTable.getCellFormatter().setStyleName(row, 1, "datatype");
    			propLabel.addClickHandler(new PropertyClickHandler(property));
                mapPropertyToRow.put(property.getEntity().getURI(), row);
    		}
    	}
    	getPropertyDefinitions(mapNoDefPropertyToUIObject);
    }
    
    private void addRange(HorizontalPanel typePanel, boolean isRequired, EIClass range) {
        String typeString = range.getEntity().getLabel();
        if (isRequired) {
            typeString += "*";
        }
        TermSearchRequest request = new TermSearchRequest();
        request.setBinding(new TermSearchRequest.TypeBinding(range.getEntity().getURI()));
        Hyperlink rangeLink = new Hyperlink(typeString, request.toURLParams());
        rangeLink.setStylePrimaryName("rangeLink");
        typePanel.add(rangeLink);        
    }
    
    private void setPropertyDefinitionTooltip(EIProperty prop, UIObject ui, HashMap<EIProperty,UIObject> mapNoDefPropertyToUIObject) {
        // Set tooltip with the definition.
        // If definition is not in cache, it will be fetched and
        // set async.
        if (prop.getDefinition() == null) {
        	mapNoDefPropertyToUIObject.put(prop, ui);
        } else {
            ui.setTitle(prop.getDefinition() + "\r\n" + prop.getEntity().getURI().toString());
        }
    }

    private void getPropertyDefinitions(final HashMap<EIProperty,UIObject> mapNoDefPropertyToUIObject) {
        // Asynchronously populate tooltips
        if (mapNoDefPropertyToUIObject.size() > 0) {
            final List<EIProperty> listNoDefProperties = new ArrayList<EIProperty>(mapNoDefPropertyToUIObject.keySet());
            ClientModelManager.INSTANCE.getPropertyDefinitions(listNoDefProperties, new PropertyDefinitionCallback() {
                @Override
                public void onSuccess(List<EIProperty> result) {
                    for (EIProperty prop : result) {
                        UIObject o = mapNoDefPropertyToUIObject.get(prop);
                        o.setTitle(prop.getDefinition());
                    }
                }
            });
        }            
    }

	public void fillInferredTypePanel(EIClass c) {
		inferredTypePanel.clear();
        ArrayList<EIClass> listAncestors = new ArrayList<EIClass>();
        EIClass parent = c.getSuperClass();
        while (parent != null) {
            listAncestors.add(parent);
            parent = parent.getSuperClass();
        }
        if (listAncestors.size() > 0) {
            for (int i = listAncestors.size() - 1; i >= 0; i--) {
            	EIClass a = listAncestors.get(i);
                String typeString = a.getEntity().getLabel();
                TermSearchRequest request = new TermSearchRequest();
                request.setBinding(new TermSearchRequest.TypeBinding(a.getEntity().getURI()));
		        Hyperlink rangeLink = new Hyperlink(typeString, request.toURLParams());
		        rangeLink.setStylePrimaryName("inferredTypeLink");
		        inferredTypePanel.add(rangeLink);
		        if (i > 0) {
		        	Label inferredTypeSeparator = new Label(",");
		        	inferredTypePanel.add(inferredTypeSeparator);
		        	inferredTypeSeparator.setStyleName("inferredTypeSeparator");
		        }
            }
            definitionTable.getRowFormatter().setVisible(0, true);
        } else {
            definitionTable.getRowFormatter().setVisible(0, false);
        }
	}
}
