/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.webapp.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.eaglei.model.webapp.client.Comment;
import org.eaglei.model.webapp.client.rpc.CommentService;
import org.eaglei.model.webapp.server.email.EmailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class CommentServlet
extends RemoteServiceServlet
implements CommentService {
    protected static final Log logger = LogFactory.getLog(CommentServlet.class);
    @Autowired
    private EmailService emailService;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)config.getServletContext());
    }

    public String submitTermComment(Comment comment) throws LoggedException {
        try {
            return this.emailService.send(comment);
        }
        catch (Throwable t) {
            logger.error((Object)"Error in submitTermComment: ", t);
            throw new LoggedException();
        }
    }

    public String submitTermRequest(Comment comment) throws LoggedException {
        try {
            return this.emailService.send(comment);
        }
        catch (Throwable t) {
            logger.error((Object)"Error in submitTermRequest: ", t);
            throw new LoggedException();
        }
    }
}

