package org.eaglei.model.webapp.server;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.eaglei.model.webapp.client.Comment;
import org.eaglei.model.webapp.client.rpc.CommentService;
import org.eaglei.model.webapp.server.email.EmailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class CommentServlet extends RemoteServiceServlet implements CommentService {

    protected static final Log logger = LogFactory.getLog(CommentServlet.class);

    @Autowired
    private EmailService emailService;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext(this, 
                config.getServletContext());
    }

    @Override
    public String submitTermComment(Comment comment) throws LoggedException {
        try {
            return emailService.send(comment);
        } catch (Throwable t) {
            logger.error("Error in submitTermComment: ", t);
            throw new LoggedException();
        }
    }

    @Override
    public String submitTermRequest(Comment comment) throws LoggedException {
        try {
            return emailService.send(comment);
        } catch (Throwable t) {
            logger.error("Error in submitTermRequest: ", t);
            throw new LoggedException();
        }
    }

}
