/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eaglei.network.actions.DummyDataQueryActionConfig;
import org.eaglei.network.actions.EagleIConfigTool;
import org.eaglei.network.actions.RDFQueryActionConfig;
import org.eaglei.search.config.SearchConfiguration;
import org.spin.tools.JAXBUtils;
import org.spin.tools.RandomTool;
import org.spin.tools.config.SPINRuntimeConfig;

public final class EagleIConfigToolTest
extends TestCase {
    public EagleIConfigToolTest() {
        SPINRuntimeConfig.setRuntimeTest();
    }

    public void testLoadEmptySearchConfiguration() throws Exception {
        SearchConfiguration empty = EagleIConfigTool.loadEmptySearchConfiguration();
        EagleIConfigToolTest.assertNotNull((Object)empty);
        EagleIConfigToolTest.assertNotNull((Object)empty.getProperties());
        EagleIConfigToolTest.assertTrue((boolean)empty.getProperties().isEmpty());
    }

    public void testLoadDummyDataQueryActionConfig() throws Exception {
        final File file = EagleIConfigToolTest.makeFile(EagleIConfigTool.EagleINetworkModules.DummyDataQueryAction.getFileName());
        final String uri = RandomTool.randomString();
        final String label = RandomTool.randomString();
        final DummyDataQueryActionConfig config = new DummyDataQueryActionConfig(uri, label);
        EagleIConfigToolTest.deleteFileAfter(file, new Op(){

            @Override
            public void perform() throws Exception {
                EagleIConfigToolTest.this.marshalToFile(file, config);
                DummyDataQueryActionConfig loadedConfig = EagleIConfigTool.loadDummyDataQueryActionConfig();
                Assert.assertNotNull((Object)loadedConfig);
                Assert.assertEquals((String)uri, (String)loadedConfig.getInstitutionURI());
                Assert.assertEquals((String)label, (String)loadedConfig.getInstitutionLabel());
            }
        });
    }

    public void testLoadRDFQueryActionConfig() throws Exception {
        final File file = EagleIConfigToolTest.makeFile(EagleIConfigTool.EagleINetworkModules.RDFQueryAction.getFileName());
        final String url = RandomTool.randomString();
        final RDFQueryActionConfig config = new RDFQueryActionConfig(url);
        EagleIConfigToolTest.deleteFileAfter(file, new Op(){

            @Override
            public void perform() throws Exception {
                EagleIConfigToolTest.this.marshalToFile(file, config);
                RDFQueryActionConfig loadedConfig = EagleIConfigTool.loadRDFQueryActionConfig();
                Assert.assertNotNull((Object)loadedConfig);
                Assert.assertEquals((String)url, (String)loadedConfig.getRepositoryURL());
            }
        });
    }

    public void testLoadRDFQueryActionConfigWithDefault() throws Exception {
        String url = RandomTool.randomString();
        RDFQueryActionConfig defaultConfig = new RDFQueryActionConfig(url);
        RDFQueryActionConfig loadedConfig = EagleIConfigTool.loadRDFQueryActionConfig((RDFQueryActionConfig)defaultConfig);
        EagleIConfigToolTest.assertNotNull((Object)loadedConfig);
        EagleIConfigToolTest.assertEquals((String)url, (String)loadedConfig.getRepositoryURL());
        EagleIConfigToolTest.assertEquals((String)defaultConfig.getRepositoryURL(), (String)loadedConfig.getRepositoryURL());
    }

    public void testLoadSearchConfig() throws Exception {
        File file = EagleIConfigToolTest.makeFile(EagleIConfigTool.EagleINetworkModules.SearchConfiguration.getFileName());
        final HashMap<String, String> props = new HashMap<String, String>(){
            {
                this.put(RandomTool.randomString(), RandomTool.randomString());
                this.put(RandomTool.randomString(), RandomTool.randomString());
                this.put(RandomTool.randomString(), RandomTool.randomString());
            }
        };
        SearchConfiguration config = new SearchConfiguration((Reader)new StringReader(""));
        EagleIConfigToolTest.assertNotNull((Object)config.getProperties());
        EagleIConfigToolTest.assertTrue((boolean)config.getProperties().isEmpty());
        config.getProperties().putAll((Map<?, ?>)props);
        config.getProperties().store(new FileWriter(file), "");
        EagleIConfigToolTest.deleteFileAfter(file, new Op(){

            @Override
            public void perform() throws Exception {
                SearchConfiguration loadedConfig = EagleIConfigTool.loadSearchConfiguration();
                Assert.assertNotNull((Object)loadedConfig);
                for (String key : props.keySet()) {
                    Assert.assertEquals((String)((String)props.get(key)), (String)loadedConfig.getProperties().getProperty(key));
                }
            }
        });
    }

    public void testWriteRDFQueryActionConfig() throws Exception {
        final String url = RandomTool.randomString();
        RDFQueryActionConfig config = new RDFQueryActionConfig(url);
        EagleIConfigTool.writeRDFQueryActionConfig((RDFQueryActionConfig)config);
        File file = EagleIConfigToolTest.makeFile(EagleIConfigTool.EagleINetworkModules.RDFQueryAction.getFileName());
        EagleIConfigToolTest.deleteFileAfter(file, new Op(){

            @Override
            public void perform() throws Exception {
                RDFQueryActionConfig loadedConfig = EagleIConfigTool.loadRDFQueryActionConfig();
                Assert.assertNotNull((Object)loadedConfig);
                Assert.assertEquals((String)url, (String)loadedConfig.getRepositoryURL());
            }
        });
    }

    public void testWriteDummyDataQueryActionConfig() throws Exception {
        final String uri = RandomTool.randomString();
        final String label = RandomTool.randomString();
        DummyDataQueryActionConfig config = new DummyDataQueryActionConfig(uri, label);
        EagleIConfigTool.writeDummyDataQueryActionConfig((DummyDataQueryActionConfig)config);
        File file = EagleIConfigToolTest.makeFile(EagleIConfigTool.EagleINetworkModules.DummyDataQueryAction.getFileName());
        EagleIConfigToolTest.deleteFileAfter(file, new Op(){

            @Override
            public void perform() throws Exception {
                DummyDataQueryActionConfig loadedConfig = EagleIConfigTool.loadDummyDataQueryActionConfig();
                Assert.assertNotNull((Object)loadedConfig);
                Assert.assertEquals((String)uri, (String)loadedConfig.getInstitutionURI());
                Assert.assertEquals((String)label, (String)loadedConfig.getInstitutionLabel());
            }
        });
    }

    public void testEagleINetworkModules() throws Exception {
        EagleIConfigToolTest.assertEquals((String)(EagleIConfigTool.EagleINetworkModules.DummyDataQueryAction.name() + ".xml"), (String)EagleIConfigTool.EagleINetworkModules.DummyDataQueryAction.getFileName());
        EagleIConfigToolTest.assertEquals((String)(EagleIConfigTool.EagleINetworkModules.RDFQueryAction.name() + ".xml"), (String)EagleIConfigTool.EagleINetworkModules.RDFQueryAction.getFileName());
        EagleIConfigToolTest.assertEquals((String)(EagleIConfigTool.EagleINetworkModules.SearchConfiguration.name() + ".properties"), (String)EagleIConfigTool.EagleINetworkModules.SearchConfiguration.getFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void marshalToFile(File file, Object config) throws IOException, JAXBException {
        assert (file != null);
        assert (config != null);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter writer = new FileWriter(file);
        try {
            JAXBUtils.marshalToWriter((Object)config, (Writer)writer);
        }
        finally {
            writer.close();
        }
    }

    private static File makeFile(String name) throws Exception {
        return new File(SPINRuntimeConfig.getHomeDir() + "/test/conf/" + name).getCanonicalFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFileAfter(File file, Op fileAction) throws Exception {
        if (fileAction != null) {
            try {
                fileAction.perform();
            }
            finally {
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
        }
    }

    static interface Op {
        public void perform() throws Exception;
    }
}

