/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import com.hp.hpl.jena.ontology.OntResource;
import junit.framework.Assert;
import org.eaglei.model.EIURI;
import org.eaglei.network.actions.ResultCheckingStrategy;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResultSet;
import org.spin.node.actions.QueryAction;

public final class QueryTestUtils {
    private QueryTestUtils() {
    }

    public static void doPerformTest(QueryAction<SearchRequest> action, SearchRequest request) throws Exception {
        QueryTestUtils.doPerformTest(action, request, ResultCheckingStrategy.RequireAtLeastOneResult);
    }

    public static void doPerformTest(QueryAction<SearchRequest> action, SearchRequest request, ResultCheckingStrategy resultCheckingStrategy) throws Exception {
        assert (action != null);
        assert (request != null);
        assert (resultCheckingStrategy != null);
        String result = action.perform(null, (Object)request);
        Assert.assertNotNull((String)"Should have non-null result", (Object)result);
        Assert.assertTrue((String)"Result shouldn't be zero-length", (result.length() > 0 ? 1 : 0) != 0);
        SearchResultSet unmarshalled = (SearchResultSet)Serializer.SearchResultSetSerializer.deserialize(result);
        QueryTestUtils.doSearchResultsTest(unmarshalled, resultCheckingStrategy);
    }

    public static void doSearchResultsTest(SearchResultSet searchResultSet) {
        QueryTestUtils.doSearchResultsTest(searchResultSet, ResultCheckingStrategy.RequireAtLeastOneResult);
    }

    public static void doSearchResultsTest(SearchResultSet searchResultSet, ResultCheckingStrategy resultCheckingStrategy) {
        assert (resultCheckingStrategy != null);
        Assert.assertNotNull((Object)searchResultSet);
        resultCheckingStrategy.checkResults(searchResultSet);
    }

    public static SearchRequest searchRequestForUniversity(OntResource university) {
        SearchRequest request = new SearchRequest();
        request.setInstitution(EIURI.create((String)university.getURI()));
        return request;
    }
}

