/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.io;

import com.clarkparsia.owlapiv3.OWL;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.OWLXMLOntologyFormat;
import org.semanticweb.owlapi.io.StreamDocumentTarget;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxonomyPersistence {
    public static final Logger log = Logger.getLogger(TaxonomyPersistence.class.getName());
    private static IRI TAXONOMY_ONTOLOGY_IRI = IRI.create((String)"http://clarkparsia.com/pellet/modularity/taxonomy");

    public static void save(Taxonomy<OWLClass> taxonomy, OutputStream outputStream) throws IOException {
        try {
            OWLOntology ontology = TaxonomyPersistence.createTaxonomyOntology(taxonomy);
            OWL.manager.saveOntology(ontology, (OWLOntologyFormat)new OWLXMLOntologyFormat(), (OWLOntologyDocumentTarget)new StreamDocumentTarget(outputStream));
            outputStream.flush();
            OWL.manager.removeOntology(ontology);
        }
        catch (OWLException e2) {
            log.log(Level.SEVERE, "An error occured while creating an ontology for taxonomy", e2);
            throw new IOException("An error occured while creating an ontology for taxonomy");
        }
    }

    private static OWLOntology createTaxonomyOntology(Taxonomy<OWLClass> taxonomy) throws OWLOntologyCreationException, OWLOntologyChangeException {
        OWLOntology ontology = OWL.Ontology(Collections.emptyList(), TAXONOMY_ONTOLOGY_IRI);
        LinkedList<AddAxiom> changes = new LinkedList<AddAxiom>();
        HashSet<OWLClass> processedEquivalentClasses = new HashSet<OWLClass>();
        for (TaxonomyNode<OWLClass> taxonomyNode : taxonomy.getNodes()) {
            Collection individuals;
            if (processedEquivalentClasses.contains(taxonomyNode.getName())) continue;
            processedEquivalentClasses.addAll(taxonomyNode.getEquivalents());
            for (OWLClass owlClass : taxonomyNode.getEquivalents()) {
                AddAxiom classAxiom = new AddAxiom(ontology, (OWLAxiom)OWL.declaration((OWLEntity)owlClass));
                changes.add(classAxiom);
                for (TaxonomyNode<OWLClass> superNode : taxonomyNode.getSupers()) {
                    AddAxiom subClassOfAxiom = new AddAxiom(ontology, (OWLAxiom)OWL.subClassOf((OWLClassExpression)owlClass, (OWLClassExpression)superNode.getName()));
                    changes.add(subClassOfAxiom);
                }
            }
            if (taxonomyNode.getEquivalents().size() > 1) {
                AddAxiom equivalentAxiom = new AddAxiom(ontology, (OWLAxiom)OWL.equivalentClasses(taxonomyNode.getEquivalents()));
                changes.add(equivalentAxiom);
            }
            if ((individuals = (Collection)taxonomyNode.getDatum(TaxonomyUtils.INSTANCES_KEY)) == null || individuals.isEmpty()) continue;
            for (OWLNamedIndividual ind : individuals) {
                AddAxiom classAssertionAxiom = new AddAxiom(ontology, (OWLAxiom)OWL.classAssertion((OWLIndividual)ind, (OWLClassExpression)taxonomyNode.getName()));
                changes.add(classAssertionAxiom);
            }
        }
        OWL.manager.applyChanges(changes);
        return ontology;
    }

    private static Set<OWLClass> getSuperClasses(OWLOntology ontology, OWLClass owlClass) {
        HashSet<OWLClass> superClasses = new HashSet<OWLClass>();
        for (OWLSubClassOfAxiom superClassAxiom : ontology.getSubClassAxiomsForSubClass(owlClass)) {
            OWLClassExpression owlSuperDescription = superClassAxiom.getSuperClass();
            if (!(owlSuperDescription instanceof OWLClass)) continue;
            superClasses.add((OWLClass)owlSuperDescription);
        }
        return superClasses;
    }

    private static Taxonomy<OWLClass> createTaxonomy(OWLOntology ontology) {
        Taxonomy<OWLClass> taxonomy = new Taxonomy<OWLClass>(null, OWL.Thing, OWL.Nothing);
        HashSet<Object> processedEquivalentClasses = new HashSet<Object>();
        processedEquivalentClasses.add(OWL.Thing);
        processedEquivalentClasses.add(OWL.Nothing);
        for (OWLClass oWLClass : ontology.getClassesInSignature()) {
            if (processedEquivalentClasses.contains(oWLClass)) continue;
            HashSet equivalentClasses = new HashSet();
            boolean equivalentToThing = false;
            boolean equivalentToNothing = false;
            for (OWLEquivalentClassesAxiom equivalentAxiom : ontology.getEquivalentClassesAxioms(oWLClass)) {
                equivalentClasses.addAll(equivalentAxiom.getNamedClasses());
                if (equivalentAxiom.containsOWLNothing()) {
                    equivalentToNothing = true;
                }
                if (!equivalentAxiom.containsOWLThing()) continue;
                equivalentToThing = true;
            }
            equivalentClasses.removeAll(processedEquivalentClasses);
            if (equivalentToThing) {
                taxonomy.addEquivalents(OWL.Thing, equivalentClasses);
            } else if (equivalentToNothing) {
                taxonomy.addEquivalents(OWL.Nothing, equivalentClasses);
            } else {
                if (equivalentClasses.contains(oWLClass)) {
                    equivalentClasses.remove(oWLClass);
                }
                taxonomy.addNode(oWLClass, false);
                taxonomy.addEquivalents(oWLClass, equivalentClasses);
            }
            processedEquivalentClasses.add(oWLClass);
            processedEquivalentClasses.addAll(equivalentClasses);
        }
        for (TaxonomyNode taxonomyNode : taxonomy.getNodes()) {
            if (!OWL.Nothing.equals(taxonomyNode.getName()) || taxonomyNode.getSupers().size() <= 1 || !taxonomyNode.getSupers().contains(taxonomy.getTop())) continue;
            taxonomy.getTop().removeSub(taxonomyNode);
        }
        for (TaxonomyNode taxonomyNode : taxonomy.getNodes()) {
            OWLClass owlClass = (OWLClass)taxonomyNode.getName();
            if (owlClass == null || owlClass.equals(OWL.Nothing)) continue;
            taxonomy.addSupers(owlClass, TaxonomyPersistence.getSuperClasses(ontology, owlClass));
        }
        for (TaxonomyNode taxonomyNode : taxonomy.getNodes()) {
            HashSet<OWLNamedIndividual> individuals = null;
            for (OWLClassAssertionAxiom classAssertionAxiom : ontology.getClassAssertionAxioms((OWLClass)taxonomyNode.getName())) {
                OWLIndividual individual = classAssertionAxiom.getIndividual();
                if (!individual.isNamed() || !(individual instanceof OWLNamedIndividual)) continue;
                if (individuals == null) {
                    individuals = new HashSet<OWLNamedIndividual>();
                }
                individuals.add((OWLNamedIndividual)individual);
            }
            if (individuals == null) continue;
            taxonomyNode.putDatum(TaxonomyUtils.INSTANCES_KEY, individuals);
        }
        return taxonomy;
    }

    public static Taxonomy<OWLClass> load(InputStream is) throws IOException {
        try {
            OWLOntology ontology = OWL.manager.loadOntologyFromOntologyDocument(is);
            Taxonomy<OWLClass> result = TaxonomyPersistence.createTaxonomy(ontology);
            OWL.manager.removeOntology(ontology);
            return result;
        }
        catch (OWLOntologyCreationException e2) {
            log.log(Level.SEVERE, "Unable to create the ontology", e2);
            throw new IOException("Unable to create the ontology");
        }
    }
}

