/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import com.clarkparsia.pellet.datatypes.DataRange;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataValueEnumeration<T>
implements DataRange<T> {
    private final Set<T> values;
    private final int size;

    public DataValueEnumeration(Collection<? extends T> values) {
        if (values == null) {
            throw new NullPointerException();
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.values = Collections.unmodifiableSet(new LinkedHashSet<T>(values));
        this.size = this.values.size();
    }

    @Override
    public boolean contains(Object value) {
        return this.values.contains(value);
    }

    @Override
    public boolean containsAtLeast(int n) {
        return this.size >= n;
    }

    @Override
    public T getValue(int i) {
        if (i >= this.size) {
            throw new NoSuchElementException();
        }
        Iterator<T> it = this.values.iterator();
        for (int j = 0; j < i; ++j) {
            it.next();
        }
        return it.next();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> valueIterator() {
        return this.values.iterator();
    }

    public String toString() {
        return String.format("OneOf%s", this.values);
    }
}

