/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.MultiValueMap;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLStringLiteral;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTypedLiteral;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletVisitor
implements OWLObjectVisitor {
    private static final long serialVersionUID = 8211773146996997500L;
    public static Logger log = Logger.getLogger(PelletVisitor.class.getName());
    private KnowledgeBase kb;
    private ATermAppl term;
    private AtomDObject swrlDObject;
    private AtomIObject swrlIObject;
    private RuleAtom swrlAtom;
    private boolean addAxioms;
    private boolean reloadRequired;
    private Set<OWLAxiom> unsupportedAxioms;
    private MultiValueMap<OWLObjectProperty, OWLObjectPropertyAxiom> compositePropertyAxioms;
    private Set<OWLObjectProperty> simpleProperties;

    public PelletVisitor(KnowledgeBase kb) {
        this.kb = kb;
        this.clear();
    }

    public void clear() {
        this.unsupportedAxioms = new HashSet<OWLAxiom>();
        this.compositePropertyAxioms = new MultiValueMap();
        this.simpleProperties = new HashSet<OWLObjectProperty>();
    }

    private void addUnsupportedAxiom(OWLAxiom axiom) {
        if (!PelletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException("Axiom: " + axiom);
        }
        if (this.unsupportedAxioms.add(axiom)) {
            log.warning("Ignoring unsupported axiom: " + axiom);
        }
    }

    public Set<OWLAxiom> getUnsupportedAxioms() {
        return new HashSet<OWLAxiom>(this.unsupportedAxioms);
    }

    private OWLObjectProperty getNamedProperty(OWLObjectPropertyExpression ope) {
        if (ope.isAnonymous()) {
            return this.getNamedProperty(((OWLObjectInverseOf)ope).getInverse());
        }
        return ope.asOWLObjectProperty();
    }

    private void addSimpleProperty(OWLObjectPropertyExpression ope) {
        if (!this.addAxioms) {
            return;
        }
        OWLObjectProperty prop = this.getNamedProperty(ope);
        this.simpleProperties.add(prop);
        prop.accept((OWLObjectVisitor)this);
        Role role = this.kb.getRBox().getRole(this.term);
        role.setForceSimple(true);
    }

    void verify() {
        for (Map.Entry entry : this.compositePropertyAxioms.entrySet()) {
            OWLObjectProperty nonSimpleProperty = (OWLObjectProperty)entry.getKey();
            if (!this.simpleProperties.contains(nonSimpleProperty)) continue;
            Set axioms = (Set)entry.getValue();
            for (OWLObjectPropertyAxiom axiom : axioms) {
                this.addUnsupportedAxiom((OWLAxiom)axiom);
            }
            ATermAppl name = ATermUtils.makeTermAppl(nonSimpleProperty.getIRI().toString());
            Role role = this.kb.getRBox().getRole(name);
            role.removeSubRoleChains();
        }
    }

    public void setAddAxiom(boolean addAxioms) {
        this.addAxioms = addAxioms;
    }

    public boolean isReloadRequired() {
        return this.reloadRequired;
    }

    public ATermAppl result() {
        return this.term;
    }

    public void reset() {
        this.term = null;
        this.reloadRequired = false;
    }

    public void visit(OWLClass c) {
        this.term = c.isOWLThing() ? ATermUtils.TOP : (c.isOWLNothing() ? ATermUtils.BOTTOM : ATermUtils.makeTermAppl(c.getIRI().toString()));
        if (this.addAxioms) {
            this.kb.addClass(this.term);
        }
    }

    public void visit(OWLAnnotationProperty prop) {
        this.term = ATermUtils.makeTermAppl(prop.getIRI().toString());
        if (this.addAxioms) {
            this.kb.addAnnotationProperty(this.term);
        }
    }

    public void visit(OWLAnonymousIndividual ind) {
        this.term = ATermUtils.makeBnode(ind.toStringID());
        if (this.addAxioms) {
            this.kb.addIndividual(this.term);
        }
    }

    public void visit(OWLNamedIndividual ind) {
        this.term = ATermUtils.makeTermAppl(ind.getIRI().toString());
        if (this.addAxioms) {
            this.kb.addIndividual(this.term);
        }
    }

    public void visit(OWLObjectProperty prop) {
        if (prop.isOWLTopObjectProperty()) {
            this.term = ATermUtils.TOP_OBJECT_PROPERTY;
        } else if (prop.isOWLBottomObjectProperty()) {
            this.term = ATermUtils.BOTTOM_OBJECT_PROPERTY;
        } else {
            this.term = ATermUtils.makeTermAppl(prop.getIRI().toString());
            if (this.addAxioms) {
                this.kb.addObjectProperty(this.term);
            }
        }
    }

    public void visit(OWLObjectInverseOf propInv) {
        propInv.getInverse().accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.term = ATermUtils.makeInv(p);
    }

    public void visit(OWLDataProperty prop) {
        if (prop.isOWLTopDataProperty()) {
            this.term = ATermUtils.TOP_DATA_PROPERTY;
        } else if (prop.isOWLBottomDataProperty()) {
            this.term = ATermUtils.BOTTOM_DATA_PROPERTY;
        } else {
            this.term = ATermUtils.makeTermAppl(prop.getIRI().toString());
            if (this.addAxioms) {
                this.kb.addDatatypeProperty(this.term);
            }
        }
    }

    public void visit(OWLTypedLiteral constant) {
        String lexicalValue = constant.getLiteral();
        constant.getDatatype().accept((OWLObjectVisitor)this);
        ATermAppl datatype = this.term;
        this.term = ATermUtils.makeTypedLiteral(lexicalValue, datatype.toString());
    }

    public void visit(OWLStringLiteral constant) {
        String lexicalValue = constant.getLiteral();
        String lang = constant.getLang();
        this.term = lang != null ? ATermUtils.makePlainLiteral(lexicalValue, lang) : ATermUtils.makePlainLiteral(lexicalValue);
    }

    public void visit(OWLDatatype ocdt) {
        this.term = ATermUtils.makeTermAppl(ocdt.getIRI().toString());
        this.kb.addDatatype(this.term);
    }

    public void visit(OWLObjectIntersectionOf and) {
        Set operands = and.getOperands();
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLClassExpression desc : operands) {
            desc.accept((OWLObjectVisitor)this);
            terms[size++] = this.term;
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeAnd(setOfTerms);
    }

    public void visit(OWLObjectUnionOf or) {
        Set operands = or.getOperands();
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLClassExpression desc : operands) {
            desc.accept((OWLObjectVisitor)this);
            terms[size++] = this.term;
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeOr(setOfTerms);
    }

    public void visit(OWLObjectComplementOf not2) {
        OWLClassExpression desc = not2.getOperand();
        desc.accept((OWLObjectVisitor)this);
        this.term = ATermUtils.makeNot(this.term);
    }

    public void visit(OWLObjectOneOf enumeration) {
        Set operands = enumeration.getIndividuals();
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLIndividual ind : operands) {
            ind.accept((OWLObjectVisitor)this);
            terms[size++] = ATermUtils.makeValue(this.term);
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeOr(setOfTerms);
    }

    public void visit(OWLObjectSomeValuesFrom restriction) {
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLClassExpression)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeSomeValues(p, c);
    }

    public void visit(OWLObjectAllValuesFrom restriction) {
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLClassExpression)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeAllValues(p, c);
    }

    public void visit(OWLObjectHasValue restriction) {
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLIndividual)restriction.getValue()).accept((OWLObjectVisitor)this);
        ATermAppl ind = this.term;
        this.term = ATermUtils.makeHasValue(p, ind);
    }

    public void visit(OWLObjectExactCardinality restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLClassExpression)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeCard(p, n, desc);
    }

    public void visit(OWLObjectMaxCardinality restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLClassExpression)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeMax((ATerm)p, n, (ATerm)desc);
    }

    public void visit(OWLObjectMinCardinality restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLClassExpression)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeMin((ATerm)p, n, (ATerm)desc);
    }

    public void visit(OWLDataExactCardinality restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeCard(p, n, desc);
    }

    public void visit(OWLDataMaxCardinality restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeMax((ATerm)p, n, (ATerm)desc);
    }

    public void visit(OWLDataMinCardinality restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeMin((ATerm)p, n, (ATerm)desc);
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        Set descriptions = axiom.getClassExpressions();
        int size = descriptions.size();
        if (size > 1) {
            ATermAppl[] terms = new ATermAppl[size];
            int index = 0;
            for (OWLClassExpression desc : descriptions) {
                desc.accept((OWLObjectVisitor)this);
                terms[index++] = this.term;
            }
            Arrays.sort(terms, 0, size, Comparators.termComparator);
            ATermAppl c1 = terms[0];
            for (int i = 1; i < terms.length; ++i) {
                ATermAppl c2 = terms[i];
                if (this.addAxioms) {
                    this.kb.addEquivalentClass(c1, c2);
                    continue;
                }
                ATermAppl sameAxiom = ATermUtils.makeEqClasses(c1, c2);
                boolean bl = this.reloadRequired = !this.kb.removeAxiom(sameAxiom);
                if (!this.reloadRequired) continue;
                return;
            }
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        Set descriptions = axiom.getClassExpressions();
        int size = descriptions.size();
        if (size > 1) {
            ATerm[] terms = new ATermAppl[size];
            int index = 0;
            for (OWLClassExpression desc : descriptions) {
                desc.accept((OWLObjectVisitor)this);
                terms[index++] = this.term;
            }
            ATermList list = ATermUtils.toSet(terms, size);
            if (this.addAxioms) {
                this.kb.addDisjointClasses(list);
            } else {
                this.reloadRequired = !this.kb.removeAxiom(ATermUtils.makeDisjoints(list));
            }
        }
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        ATermAppl c1 = this.term;
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        ATermAppl c2 = this.term;
        if (this.addAxioms) {
            this.kb.addSubClass(c1, c2);
        } else {
            ATermAppl subAxiom = ATermUtils.makeSub(c1, c2);
            this.reloadRequired = !this.kb.removeAxiom(subAxiom);
        }
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        int size = axiom.getProperties().size();
        OWLObjectPropertyExpression[] props = new OWLObjectPropertyExpression[size];
        axiom.getProperties().toArray(props);
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                props[i].accept((OWLObjectVisitor)this);
                ATermAppl p1 = this.term;
                props[j].accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                this.kb.addEquivalentProperty(p1, p2);
            }
        }
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        int size = axiom.getProperties().size();
        OWLDataPropertyExpression[] props = new OWLDataPropertyExpression[size];
        axiom.getProperties().toArray(props);
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                props[i].accept((OWLObjectVisitor)this);
                ATermAppl p1 = this.term;
                props[j].accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                this.kb.addEquivalentProperty(p1, p2);
            }
        }
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        if (axiom.getIndividuals().size() == 2) {
            Iterator iter = axiom.getIndividuals().iterator();
            ((OWLIndividual)iter.next()).accept((OWLObjectVisitor)this);
            ATermAppl i1 = this.term;
            ((OWLIndividual)iter.next()).accept((OWLObjectVisitor)this);
            ATermAppl i2 = this.term;
            this.kb.addDifferent(i1, i2);
        } else {
            ATerm[] terms = new ATermAppl[axiom.getIndividuals().size()];
            int i = 0;
            for (OWLIndividual ind : axiom.getIndividuals()) {
                ind.accept((OWLObjectVisitor)this);
                terms[i++] = this.term;
            }
            this.kb.addAllDifferent(ATermUtils.makeList(terms));
        }
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Iterator eqs = axiom.getIndividuals().iterator();
        if (eqs.hasNext()) {
            ((OWLIndividual)eqs.next()).accept((OWLObjectVisitor)this);
            ATermAppl i1 = this.term;
            while (eqs.hasNext()) {
                ((OWLIndividual)eqs.next()).accept((OWLObjectVisitor)this);
                ATermAppl i2 = this.term;
                this.kb.addSame(i1, i2);
            }
        }
    }

    public void visit(OWLHasKeyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        HashSet<ATermAppl> properties = new HashSet<ATermAppl>();
        for (OWLPropertyExpression pe : axiom.getPropertyExpressions()) {
            pe.accept((OWLObjectVisitor)this);
            properties.add(this.term);
        }
        this.kb.addKey(c, properties);
    }

    public void visit(OWLDataOneOf enumeration) {
        ATermList ops = ATermUtils.EMPTY_LIST;
        for (OWLLiteral value : enumeration.getValues()) {
            value.accept((OWLObjectVisitor)this);
            ops = ops.insert(ATermUtils.makeValue(this.result()));
        }
        this.term = ATermUtils.makeOr(ops);
    }

    public void visit(OWLDataAllValuesFrom restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeAllValues(p, c);
    }

    public void visit(OWLDataSomeValuesFrom restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeSomeValues(p, c);
    }

    public void visit(OWLDataHasValue restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLLiteral)restriction.getValue()).accept((OWLObjectVisitor)this);
        ATermAppl dv = this.term;
        this.term = ATermUtils.makeHasValue(p, dv);
    }

    public void visit(OWLOntology ont) {
        for (OWLEntity entity : ont.getSignature()) {
            entity.accept((OWLObjectVisitor)this);
        }
        for (OWLAxiom axiom : ont.getAxioms()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Load " + axiom);
            }
            axiom.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLObjectHasSelf restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.term = ATermUtils.makeSelf(p);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        OWLObjectPropertyExpression[] disjs = axiom.getProperties().toArray(new OWLObjectPropertyExpression[0]);
        for (int i = 0; i < disjs.length - 1; ++i) {
            OWLObjectPropertyExpression prop1 = disjs[i];
            this.addSimpleProperty(prop1);
            for (int j = i + 1; j < disjs.length; ++j) {
                OWLObjectPropertyExpression prop2 = disjs[j];
                this.addSimpleProperty(prop2);
                prop1.accept((OWLObjectVisitor)this);
                ATermAppl p1 = this.term;
                prop2.accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                this.kb.addDisjointProperty(p1, p2);
            }
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Object[] disjs = axiom.getProperties().toArray();
        for (int i = 0; i < disjs.length; ++i) {
            OWLDataProperty desc1 = (OWLDataProperty)disjs[i];
            desc1.accept((OWLObjectVisitor)this);
            ATermAppl p1 = this.term;
            for (int j = i + 1; j < disjs.length; ++j) {
                OWLDataProperty desc2 = (OWLDataProperty)disjs[j];
                desc2.accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                this.kb.addDisjointProperty(p1, p2);
            }
        }
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.compositePropertyAxioms.add(this.getNamedProperty(axiom.getSuperProperty()), (OWLObjectPropertyAxiom)axiom);
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        ATermAppl prop = this.result();
        List propChain = axiom.getPropertyChain();
        ATermList chain = ATermUtils.EMPTY_LIST;
        for (int i = propChain.size() - 1; i >= 0; --i) {
            ((OWLObjectPropertyExpression)propChain.get(i)).accept((OWLObjectVisitor)this);
            chain = chain.insert(this.result());
        }
        this.kb.addSubProperty(chain, prop);
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getOWLClass().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        ATermList classes = ATermUtils.EMPTY_LIST;
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            desc.accept((OWLObjectVisitor)this);
            classes = classes.insert(this.result());
        }
        this.kb.addDisjointClasses(classes);
        this.kb.addEquivalentClass(c, ATermUtils.makeOr(classes));
    }

    public void visit(OWLDataComplementOf node) {
        node.getDataRange().accept((OWLObjectVisitor)this);
        this.term = ATermUtils.makeNot(this.term);
    }

    public void visit(OWLDataIntersectionOf and) {
        Set operands = and.getOperands();
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLDataRange desc : operands) {
            desc.accept((OWLObjectVisitor)this);
            terms[size++] = this.term;
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeAnd(setOfTerms);
    }

    public void visit(OWLDatatypeRestriction node) {
        node.getDatatype().accept((OWLObjectVisitor)this);
        ATermAppl baseDatatype = this.term;
        ArrayList<ATermAppl> restrictions = new ArrayList<ATermAppl>();
        for (OWLFacetRestriction restr : node.getFacetRestrictions()) {
            restr.accept((OWLObjectVisitor)this);
            if (this.term != null) {
                restrictions.add(this.term);
                continue;
            }
            log.warning("Unrecognized facet " + restr.getFacet());
            return;
        }
        if (restrictions.isEmpty()) {
            log.warning("A data range is defined without facet restrictions " + node);
        } else {
            this.term = ATermUtils.makeRestrictedDatatype(baseDatatype, restrictions.toArray(new ATermAppl[restrictions.size()]));
        }
    }

    public void visit(OWLDataUnionOf or) {
        Set operands = or.getOperands();
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLDataRange desc : operands) {
            desc.accept((OWLObjectVisitor)this);
            terms[size++] = this.term;
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeOr(setOfTerms);
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addAsymmetricProperty(p);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addReflexiveProperty(p);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addFunctionalProperty(p);
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl s = this.term;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl o = this.term;
        this.kb.addNegatedPropertyValue(p, s, o);
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        axiom.getDomain().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        if (this.addAxioms) {
            this.kb.addDomain(p, c);
        } else {
            this.reloadRequired = !this.kb.removeDomain(p, c);
        }
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        axiom.getDomain().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        if (this.addAxioms) {
            this.kb.addDomain(p, c);
        } else {
            this.reloadRequired = !this.kb.removeDomain(p, c);
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl s = this.term;
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl o = this.term;
        this.kb.addNegatedPropertyValue(p, s, o);
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLClassExpression)axiom.getRange()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        if (this.addAxioms) {
            this.kb.addRange(p, c);
        } else {
            this.reloadRequired = !this.kb.removeRange(p, c);
        }
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl subj = this.term;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl pred = this.term;
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl obj = this.term;
        this.kb.addPropertyValue(pred, subj, obj);
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        ATermAppl sub = this.term;
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        ATermAppl sup = this.term;
        this.kb.addSubProperty(sub, sup);
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getDatatype().accept((OWLObjectVisitor)this);
        ATermAppl datatype = this.term;
        axiom.getDataRange().accept((OWLObjectVisitor)this);
        ATermAppl datarange = this.term;
        this.kb.addDatatypeDefinition(datatype, datarange);
    }

    public void visit(OWLDeclarationAxiom axiom) {
        axiom.getEntity().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addSymmetricProperty(p);
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDataRange)axiom.getRange()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        if (this.addAxioms) {
            this.kb.addRange(p, c);
        } else {
            this.reloadRequired = !this.kb.removeRange(p, c);
        }
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addFunctionalProperty(p);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        ATermAppl ind = this.term;
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.kb.addType(ind, c);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl subj = this.term;
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl pred = this.term;
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl obj = this.term;
        this.kb.addPropertyValue(pred, subj, obj);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.compositePropertyAxioms.add(this.getNamedProperty((OWLObjectPropertyExpression)axiom.getProperty()), (OWLObjectPropertyAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addTransitiveProperty(p);
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addIrreflexiveProperty(p);
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p1 = this.term;
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p2 = this.term;
        this.kb.addSubProperty(p1, p2);
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addInverseFunctionalProperty(p);
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getFirstProperty().accept((OWLObjectVisitor)this);
        ATermAppl p1 = this.term;
        axiom.getSecondProperty().accept((OWLObjectVisitor)this);
        ATermAppl p2 = this.term;
        this.kb.addInverseProperty(p1, p2);
    }

    public void visit(OWLFacetRestriction node) {
        Facet facet = Facet.Registry.get(ATermUtils.makeTermAppl(node.getFacet().getIRI().toString()));
        if (facet != null) {
            OWLLiteral facetValue = node.getFacetValue();
            facetValue.accept((OWLObjectVisitor)this);
            this.term = ATermUtils.makeFacetRestriction(facet.getName(), this.term);
        }
    }

    public void visit(SWRLRule rule) {
        if (!PelletOptions.DL_SAFE_RULES) {
            return;
        }
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        List<RuleAtom> head = this.parseAtomList(rule.getHead());
        List<RuleAtom> body = this.parseAtomList(rule.getBody());
        if (head == null || body == null) {
            this.addUnsupportedAxiom((OWLAxiom)rule);
            return;
        }
        Rule pelletRule = new Rule(head, body);
        this.kb.addRule(pelletRule);
    }

    public void visit(OWLAnnotation a) {
        throw new UnsupportedOperationException();
    }

    public void visit(IRI annotationValue) {
        this.term = ATermUtils.makeTermAppl(annotationValue.toString());
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = PelletOptions.USE_ANNOTATION_SUPPORT;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl s = this.term;
        axiom.getProperty().accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        axiom.getValue().accept((OWLObjectVisitor)this);
        ATermAppl o = this.term;
        this.kb.addAnnotation(s, p, o);
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.addUnsupportedAxiom((OWLAxiom)axiom);
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.addUnsupportedAxiom((OWLAxiom)axiom);
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubProperty().accept((OWLObjectVisitor)this);
        ATermAppl sub = this.term;
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        ATermAppl sup = this.term;
        this.kb.addSubProperty(sub, sup);
    }

    private List<RuleAtom> parseAtomList(Set<SWRLAtom> atomList) {
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>();
        for (SWRLAtom atom : atomList) {
            atom.accept((OWLObjectVisitor)this);
            if (this.swrlAtom == null) {
                return null;
            }
            atoms.add(this.swrlAtom);
        }
        return atoms;
    }

    public void visit(SWRLClassAtom atom) {
        OWLClassExpression c = atom.getPredicate();
        SWRLIArgument v = (SWRLIArgument)atom.getArgument();
        v.accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        c.accept((OWLObjectVisitor)this);
        this.swrlAtom = new ClassAtom(this.term, subj);
    }

    public void visit(SWRLDataRangeAtom atom) {
        atom.getPredicate().accept((OWLObjectVisitor)this);
        ((SWRLDArgument)atom.getArgument()).accept((OWLObjectVisitor)this);
        this.swrlAtom = new DataRangeAtom(this.term, this.swrlDObject);
    }

    public void visit(SWRLObjectPropertyAtom atom) {
        if (atom.getPredicate().isAnonymous()) {
            this.swrlAtom = null;
            return;
        }
        ((SWRLIArgument)atom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        ((SWRLIArgument)atom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomIObject obj = this.swrlIObject;
        atom.getPredicate().accept((OWLObjectVisitor)this);
        this.swrlAtom = new IndividualPropertyAtom(this.term, subj, obj);
    }

    public void visit(SWRLDataPropertyAtom atom) {
        if (atom.getPredicate().isAnonymous()) {
            this.swrlAtom = null;
            return;
        }
        ((SWRLIArgument)atom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        ((SWRLDArgument)atom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomDObject obj = this.swrlDObject;
        atom.getPredicate().accept((OWLObjectVisitor)this);
        this.swrlAtom = new DatavaluedPropertyAtom(this.term, subj, obj);
    }

    public void visit(SWRLSameIndividualAtom atom) {
        ((SWRLIArgument)atom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        ((SWRLIArgument)atom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomIObject obj = this.swrlIObject;
        this.swrlAtom = new SameIndividualAtom(subj, obj);
    }

    public void visit(SWRLDifferentIndividualsAtom atom) {
        ((SWRLIArgument)atom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        ((SWRLIArgument)atom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomIObject obj = this.swrlIObject;
        this.swrlAtom = new DifferentIndividualsAtom(subj, obj);
    }

    public void visit(SWRLBuiltInAtom atom) {
        ArrayList<AtomDObject> arguments = new ArrayList<AtomDObject>(atom.getAllArguments().size());
        for (SWRLDArgument swrlArg : atom.getArguments()) {
            swrlArg.accept((OWLObjectVisitor)this);
            arguments.add(this.swrlDObject);
        }
        this.swrlAtom = new BuiltInAtom(atom.getPredicate().toString(), arguments);
    }

    public void visit(SWRLVariable var) {
        this.swrlDObject = new AtomDVariable(var.getIRI().toString());
        this.swrlIObject = new AtomIVariable(var.getIRI().toString());
    }

    public void visit(SWRLIndividualArgument iobj) {
        iobj.getIndividual().accept((OWLObjectVisitor)this);
        this.swrlIObject = new AtomIConstant(this.term);
    }

    public void visit(SWRLLiteralArgument cons) {
        cons.getLiteral().accept((OWLObjectVisitor)this);
        this.swrlDObject = new AtomDConstant(this.term);
    }
}

