/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.builtins.ComparisonTesters;
import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.builtins.StringToStringFunction;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.utils.ATermUtils;

public class StringFunctionAdapter
implements Function {
    String datatypeURI;
    StringToStringFunction function;

    public StringFunctionAdapter(StringToStringFunction function) {
        this(function, null);
    }

    public StringFunctionAdapter(StringToStringFunction function, String datatypeURI) {
        this.datatypeURI = datatypeURI;
        this.function = function;
    }

    public Literal apply(ABox abox, Literal expected, Literal ... litArgs) {
        String[] args = new String[litArgs.length];
        for (int i = 0; i < litArgs.length; ++i) {
            args[i] = ATermUtils.getLiteralValue(litArgs[i].getTerm());
        }
        String result = this.function.apply(args);
        if (result == null) {
            return null;
        }
        ATermAppl resultTerm = this.datatypeURI == null ? ATermUtils.makePlainLiteral(result) : ATermUtils.makeTypedLiteral(result, this.datatypeURI);
        Literal resultLit = abox.addLiteral(resultTerm);
        return ComparisonTesters.expectedIfEquals(expected, resultLit);
    }
}

