/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.CombinedQueryEngine;
import com.clarkparsia.pellet.sparqldl.engine.QueryExec;
import com.clarkparsia.pellet.sparqldl.engine.QueryOptimizer;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.QueryResultImpl;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.impl.QueryImpl;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class NaiveCombinedQueryExec
implements QueryExec {
    public static Logger log = Logger.getLogger(NaiveCombinedQueryExec.class.getName());
    public static final QueryExec distCombinedQueryExec = new CombinedQueryEngine();
    public static final QueryOptimizer optimizer = new QueryOptimizer();
    protected Query schemaQuery;
    protected Query aboxQuery;

    public boolean supports(Query q) {
        return true;
    }

    public QueryResult exec(Query query2) {
        QueryResult result;
        boolean shouldHaveBinding;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Executing query " + query2.getAtoms());
        }
        this.partitionQuery(query2);
        QueryResultImpl newResult = new QueryResultImpl(query2);
        if (this.schemaQuery.getAtoms().isEmpty()) {
            shouldHaveBinding = false;
            result = new QueryResultImpl(query2);
            result.add(new ResultBindingImpl());
        } else {
            result = distCombinedQueryExec.exec(this.schemaQuery);
            boolean bl = shouldHaveBinding = SetUtils.intersects(query2.getDistVarsForType(Query.VarType.CLASS), query2.getResultVars()) || SetUtils.intersects(query2.getDistVarsForType(Query.VarType.PROPERTY), query2.getResultVars());
        }
        if (shouldHaveBinding && result.isEmpty()) {
            return result;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Partial binding after schema query : " + result);
        }
        for (ResultBinding binding : result) {
            Query query22 = this.aboxQuery.apply(binding);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Query = " + query22.getAtoms());
            }
            org.mindswap.pellet.query.Query transformedQuery = this.transformQuery(query22);
            long time = System.currentTimeMillis();
            QueryResults results = QueryEngine.exec(transformedQuery);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Time=" + (System.currentTimeMillis() - time));
            }
            QueryResult result2 = this.transformResult(results, query2);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Result = " + result2);
            }
            for (ResultBinding newBinding : result2) {
                for (ATermAppl var : binding.getAllVariables()) {
                    newBinding.setValue(var, binding.getValue(var));
                }
                newResult.add(newBinding);
            }
        }
        return newResult;
    }

    private final void partitionQuery(Query query2) {
        this.schemaQuery = new com.clarkparsia.pellet.sparqldl.model.QueryImpl(query2);
        this.aboxQuery = new com.clarkparsia.pellet.sparqldl.model.QueryImpl(query2);
        for (QueryAtom atom : query2.getAtoms()) {
            switch (atom.getPredicate()) {
                case Type: 
                case PropertyValue: {
                    this.aboxQuery.add(atom);
                    break;
                }
            }
        }
        ArrayList<QueryAtom> atoms = new ArrayList<QueryAtom>(query2.getAtoms());
        atoms.removeAll(this.aboxQuery.getAtoms());
        for (QueryAtom atom : atoms) {
            this.schemaQuery.add(atom);
        }
        for (Query.VarType t : Query.VarType.values()) {
            for (ATermAppl a : query2.getDistVarsForType(t)) {
                if (this.aboxQuery.getVars().contains(a)) {
                    this.aboxQuery.addDistVar(a, t);
                }
                if (!this.schemaQuery.getVars().contains(a)) continue;
                this.schemaQuery.addDistVar(a, t);
            }
        }
        for (ATermAppl a : query2.getResultVars()) {
            if (this.aboxQuery.getVars().contains(a)) {
                this.aboxQuery.addResultVar(a);
            }
            if (!this.schemaQuery.getVars().contains(a)) continue;
            this.schemaQuery.addResultVar(a);
        }
        for (ATermAppl v : this.aboxQuery.getDistVarsForType(Query.VarType.CLASS)) {
            if (this.schemaQuery.getVars().contains(v)) continue;
            this.schemaQuery.add(QueryAtomFactory.SubClassOfAtom(v, ATermUtils.TOP));
        }
        for (ATermAppl v : this.aboxQuery.getDistVarsForType(Query.VarType.PROPERTY)) {
            if (this.schemaQuery.getVars().contains(v)) continue;
            this.schemaQuery.add(QueryAtomFactory.SubPropertyOfAtom(v, v));
        }
    }

    private final org.mindswap.pellet.query.Query transformQuery(Query query2) {
        QueryImpl result = new QueryImpl(query2.getKB(), query2.isDistinct());
        for (QueryAtom atom : query2.getAtoms()) {
            switch (atom.getPredicate()) {
                case Type: {
                    result.addTypePattern(atom.getArguments().get(0), atom.getArguments().get(1));
                    break;
                }
                case PropertyValue: {
                    result.addEdgePattern(atom.getArguments().get(0), atom.getArguments().get(1), atom.getArguments().get(2));
                    break;
                }
            }
        }
        for (ATermAppl a : query2.getDistVarsForType(Query.VarType.INDIVIDUAL)) {
            result.addDistVar(a);
        }
        for (ATermAppl a : query2.getResultVars()) {
            result.addResultVar(a);
        }
        return result;
    }

    private final QueryResult transformResult(QueryResults results, Query query2) {
        QueryResultImpl result = new QueryResultImpl(query2);
        for (int i = 0; i < results.size(); ++i) {
            QueryResultBinding binding = results.get(i);
            ResultBindingImpl newBinding = new ResultBindingImpl();
            for (Object varx : binding.getVars()) {
                ATermAppl var = (ATermAppl)varx;
                newBinding.setValue(var, binding.getValue(var));
            }
            result.add(newBinding);
        }
        return result;
    }
}

