/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseAtomicDatatype;
import org.mindswap.pellet.utils.ATermUtils;

public class RDFXMLLiteral
extends BaseAtomicDatatype
implements AtomicDatatype {
    public static final RDFXMLLiteral instance = new RDFXMLLiteral();

    RDFXMLLiteral() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"));
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    public Object getValue(String value, String datatypeURI) {
        if (datatypeURI.equals(this.name.getName())) {
            return new XMLValue(value);
        }
        return null;
    }

    public ATermAppl getValue(int n) {
        return ATermUtils.makeTypedLiteral("<text>" + n + "</text>", this.name.getName());
    }

    public boolean contains(Object value) {
        return value instanceof XMLValue && super.contains(value);
    }

    public String toString() {
        return "rdf:XMLLiteral";
    }

    static class XMLValue {
        String value;

        XMLValue(String value) {
            this.value = value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof XMLValue) {
                XMLValue otherVal = (XMLValue)obj;
                String stringVal = otherVal.value;
                return this.value.equals(stringVal);
            }
            return false;
        }

        public String toString() {
            return this.value;
        }
    }
}

