/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.mindswap.pellet.datatypes.AbstractValueSpace;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.datatypes.XSDInteger;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.mindswap.pellet.utils.NumberUtils;

public class XSDDecimal
extends BaseXSDAtomicType
implements AtomicDatatype,
XSDAtomicType {
    private static final Object min = "-Inf";
    private static final Object zero = (byte)0;
    private static final Object max = "+Inf";
    private static BigInteger MAX_INT = new BigInteger(String.valueOf(Integer.MAX_VALUE));
    public static final ValueSpace DECIMAL_VALUE_SPACE = new DecimalValueSpace(true);
    public static final ValueSpace INTEGER_VALUE_SPACE = new DecimalValueSpace(false);
    public static XSDDecimal instance = new XSDDecimal(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#decimal"), true);

    protected XSDDecimal(ATermAppl name, boolean fractionDigits) {
        super(name, fractionDigits ? DECIMAL_VALUE_SPACE : INTEGER_VALUE_SPACE);
    }

    public BaseXSDAtomicType create(GenericIntervalList intervals) {
        XSDDecimal type = new XSDDecimal(null, ((DecimalValueSpace)this.valueSpace).fractionDigits);
        type.values = intervals;
        return type;
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    public AtomicDatatype intersection(AtomicDatatype dt) {
        return dt instanceof XSDInteger && !(this instanceof XSDInteger) ? dt.intersection(this) : super.intersection(dt);
    }

    public static class DecimalValueSpace
    extends AbstractValueSpace
    implements ValueSpace {
        private boolean fractionDigits;

        public DecimalValueSpace(boolean fractionDigits) {
            super(min, zero, max, true);
            this.fractionDigits = fractionDigits;
        }

        public boolean isValid(Object value) {
            return value instanceof Number && !(value instanceof Double) && !(value instanceof Float);
        }

        public Object getValue(String literal) {
            return this.fractionDigits ? (Number)NumberUtils.parseDecimal(literal) : (Number)NumberUtils.parseInteger(literal);
        }

        public int compare(Object a, Object b) {
            Integer cmp = this.compareInternal(a, b);
            if (cmp != null) {
                return cmp;
            }
            return NumberUtils.compare((Number)a, (Number)b);
        }

        public int count(Object start, Object end) {
            Integer cmp = this.countInternal(start, end);
            if (cmp != null) {
                return cmp;
            }
            int type1 = NumberUtils.getType((Number)start);
            int type2 = NumberUtils.getType((Number)end);
            if (this.fractionDigits) {
                BigDecimal startValue;
                BigDecimal endValue = end instanceof BigDecimal ? (BigDecimal)end : new BigDecimal(end.toString());
                BigDecimal bigDecimal = startValue = start instanceof BigDecimal ? (BigDecimal)start : new BigDecimal(start.toString());
                if (endValue.compareTo(startValue) > 0) {
                    return -1;
                }
                return 0;
            }
            if (type1 > 3 || type2 > 3) {
                BigInteger endValue = end instanceof BigInteger ? (BigInteger)end : new BigInteger(end.toString());
                BigInteger startValue = start instanceof BigInteger ? (BigInteger)start : new BigInteger(start.toString());
                BigInteger count = endValue.subtract(startValue);
                if ((count = count.add(BigInteger.ONE)).compareTo(MAX_INT) > 0) {
                    return -1;
                }
                return count.intValue();
            }
            long endValue = ((Number)end).longValue();
            long startValue = ((Number)start).longValue();
            long count = endValue - startValue + 1L;
            if (startValue < 0L && 0L <= endValue && count < endValue) {
                return -1;
            }
            return count > Integer.MAX_VALUE ? -1 : (int)count;
        }

        public int count_(Object start, Object end) {
            Integer cmp = this.countInternal(start, end);
            if (cmp != null) {
                return cmp;
            }
            long endValue = ((Number)end).longValue();
            long startValue = ((Number)start).longValue();
            long count = endValue - startValue + 1L;
            if (startValue < 0L && 0L < endValue && count < endValue) {
                return -1;
            }
            return count > Integer.MAX_VALUE ? -1 : (int)count;
        }

        public Object succ(Object start, int n) {
            if (this.isInfinite(start)) {
                throw new IllegalArgumentException("Cannot handle infinite values");
            }
            return NumberUtils.add((Number)start, n);
        }

        public String getLexicalForm(Object value) {
            return value.toString();
        }
    }
}

