/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy.printer;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.TaxonomyPrinter;
import org.mindswap.pellet.utils.Comparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTaxonomyPrinter<T>
implements TaxonomyPrinter<T> {
    static final String INDENT = "  ";
    protected Taxonomy<T> taxonomy;
    protected PrintWriter out;

    @Override
    public void print(Taxonomy<T> taxonomy) {
        this.print(taxonomy, new PrintWriter(System.out));
    }

    @Override
    public void print(Taxonomy<T> taxonomy, PrintWriter out) {
        this.taxonomy = taxonomy;
        this.out = out;
        out.println();
        this.printTree();
        out.println();
        out.flush();
    }

    protected void printTree() {
        TreeSet<Object> top = new TreeSet<Object>(Comparators.stringComparator);
        top.add(this.taxonomy.getTop().getName());
        top.addAll(this.taxonomy.getTop().getEquivalents());
        this.printTree(top, " ");
        TreeSet<Object> bottom = new TreeSet<Object>(Comparators.stringComparator);
        bottom.add(this.taxonomy.getBottom().getName());
        bottom.addAll(this.taxonomy.getBottom().getEquivalents());
        if (bottom.size() > 1) {
            this.printNode(bottom, " ");
        }
    }

    protected void printTree(Set<T> set, String indent) {
        if (set.contains(this.taxonomy.getBottom().getName())) {
            return;
        }
        this.printNode(set, indent);
        T c = set.iterator().next();
        Set<Set<T>> subs = this.ss(this.taxonomy.getSubs(c, true));
        for (Set<T> eqs : subs) {
            if (eqs.contains(c)) continue;
            this.printTree(this.s(eqs), indent + "   ");
        }
    }

    protected void printNode(Set<T> set, String indent) {
        this.out.print(indent);
        this.printNode(set);
        this.out.println();
    }

    protected void printNode(Set<T> set) {
        Iterator<T> i = set.iterator();
        T c = i.next();
        this.printURI(this.out, c);
        while (i.hasNext()) {
            this.out.print(" = ");
            this.printURI(this.out, i.next());
        }
    }

    protected void printURI(PrintWriter out, T e2) {
        out.print(e2.toString());
    }

    private Set<Set<T>> ss(Set<Set<T>> subs) {
        TreeSet<Object> sorted = new TreeSet<Object>(Comparators.stringComparator);
        sorted.addAll(subs);
        return sorted;
    }

    private Set<T> s(Set<T> set) {
        TreeSet<Object> sorted = new TreeSet<Object>(Comparators.stringComparator);
        sorted.addAll(set);
        return sorted;
    }
}

