/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.writers;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.writers.WriterLib;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriterNode {
    private static final int NL = 1;
    private static final int NoNL = -1;
    private static final int NoSP = -2;

    public static void output(IndentedWriter out, Triple triple, SerializationContext naming) {
        WriterLib.start(out, "triple", -1);
        WriterNode.outputPlain(out, triple, naming);
        WriterLib.finish(out, "triple");
    }

    public static void outputPlain(IndentedWriter out, Triple triple, SerializationContext naming) {
        WriterNode.output(out, triple.getSubject(), naming);
        out.print(" ");
        WriterNode.output(out, triple.getPredicate(), naming);
        out.print(" ");
        WriterNode.output(out, triple.getObject(), naming);
    }

    public static void output(IndentedWriter out, Quad qp, SerializationContext naming) {
        WriterLib.start(out, "quad", -1);
        WriterNode.outputPlain(out, qp, naming);
        WriterLib.finish(out, "quad");
    }

    public static void outputPlain(IndentedWriter out, Quad qp, SerializationContext naming) {
        WriterNode.output(out, qp.getGraph(), naming);
        out.print(" ");
        WriterNode.output(out, qp.getSubject(), naming);
        out.print(" ");
        WriterNode.output(out, qp.getPredicate(), naming);
        out.print(" ");
        WriterNode.output(out, qp.getObject(), naming);
    }

    public static void output(IndentedWriter out, Node node, SerializationContext naming) {
        out.print(FmtUtils.stringForNode(node, naming));
    }

    public static void output(IndentedWriter out, List<Node> nodeList, SerializationContext naming) {
        out.print("(");
        boolean first = true;
        for (Node node : nodeList) {
            if (!first) {
                out.print(" ");
            }
            out.print(FmtUtils.stringForNode(node, naming));
            first = false;
        }
        out.print(")");
    }
}

