/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CJKAnalyzer
extends Analyzer {
    public static final String[] STOP_WORDS = new String[]{"a", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "s", "such", "t", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with", "", "www"};
    private final Set<?> stopTable;
    private final Version matchVersion;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public CJKAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public CJKAnalyzer(Version matchVersion, Set<?> stopwords) {
        this.stopTable = CharArraySet.unmodifiableSet(CharArraySet.copy(stopwords));
        this.matchVersion = matchVersion;
    }

    public CJKAnalyzer(Version matchVersion, String ... stopWords) {
        this.stopTable = StopFilter.makeStopSet(stopWords);
        this.matchVersion = matchVersion;
    }

    @Override
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        return new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), new CJKTokenizer(reader), this.stopTable);
    }

    @Override
    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new CJKTokenizer(reader);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), streams.source, this.stopTable);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET = CharArraySet.unmodifiableSet(new CharArraySet(Arrays.asList(STOP_WORDS), false));

        private DefaultSetHolder() {
        }
    }
}

