/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.datetime.BigTimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import java.math.BigInteger;
import org.mindswap.pellet.datatypes.AbstractDateTimeValueSpace;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.mindswap.pellet.utils.NumberUtils;
import org.relaxng.datatype.DatatypeException;

public class XSDMonthDay
extends BaseXSDAtomicType
implements AtomicDatatype,
XSDAtomicType {
    private static XSDatatype dt = null;
    private static IDateTimeValueType min = null;
    private static IDateTimeValueType max = null;
    private static final ValueSpace MONTH_DAY_VALUE_SPACE;
    public static XSDMonthDay instance;

    protected XSDMonthDay(ATermAppl name) {
        super(name, MONTH_DAY_VALUE_SPACE);
    }

    public BaseXSDAtomicType create(GenericIntervalList intervals) {
        XSDMonthDay type = new XSDMonthDay(null);
        type.values = intervals;
        return type;
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    static {
        try {
            dt = DatatypeFactory.getTypeByName((String)"gMonthDay");
            min = (IDateTimeValueType)dt.createValue("--01-01", null);
            max = (IDateTimeValueType)dt.createValue("--12-31", null);
        }
        catch (DatatypeException e2) {
            e2.printStackTrace();
        }
        MONTH_DAY_VALUE_SPACE = new MonthDayValueSpace();
        instance = new XSDMonthDay(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#gMonthDay"));
    }

    private static class MonthDayValueSpace
    extends AbstractDateTimeValueSpace
    implements ValueSpace {
        public MonthDayValueSpace() {
            super(min, max, dt);
        }

        public int count(Object start, Object end) {
            long calendarStart = ((IDateTimeValueType)start).toCalendar().getTimeInMillis();
            long calendarEnd = ((IDateTimeValueType)end).toCalendar().getTimeInMillis();
            long diff = calendarEnd - calendarStart;
            int numberOfDays = (int)(diff / 8640000L);
            return numberOfDays;
        }

        public Object succ(Object value, int n) {
            BigInteger bigN = new BigInteger(String.valueOf(n));
            BigTimeDurationValueType nDays = new BigTimeDurationValueType(NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, bigN, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.DECIMAL_ZERO);
            IDateTimeValueType s = ((IDateTimeValueType)value).add((ITimeDurationValueType)nDays);
            return s;
        }
    }
}

