/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.progress;

import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.progress.ProgressMonitor;

public abstract class AbstractProgressMonitor
implements ProgressMonitor {
    protected String progressTitle = "";
    protected String progressMessage = "";
    protected int progress = 0;
    protected int progressLength = 0;
    protected int progressPercent = -1;
    protected Timer timer = new Timer();
    protected boolean cancelled = false;

    public AbstractProgressMonitor() {
    }

    public AbstractProgressMonitor(int length) {
        this.setProgressLength(length);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressLength() {
        return this.progressLength;
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    public int getProgressPercent() {
        return this.progressPercent;
    }

    public String getProgressTitle() {
        return this.progressTitle;
    }

    public void incrementProgress() {
        this.setProgress(this.progress + 1);
    }

    public boolean isCanceled() {
        return this.cancelled;
    }

    protected void resetProgress() {
        this.progress = 0;
        this.progressPercent = -1;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.updateProgress();
    }

    public void setProgressLength(int progressLength) {
        this.progressLength = progressLength;
        this.resetProgress();
    }

    public void setProgressMessage(String progressMessage) {
        this.progressMessage = progressMessage;
    }

    public void setProgressTitle(String progressTitle) {
        this.progressTitle = progressTitle;
    }

    public void taskFinished() {
        this.timer.stop();
    }

    public void taskStarted() {
        this.resetProgress();
        this.timer.start();
    }

    protected abstract void updateProgress();
}

