package org.eaglei.network.actions;


import static org.eaglei.network.actions.SearchProviderOperations.invokesQuery;
import static org.eaglei.search.common.Serializer.SearchRequestSerializer;
import static org.eaglei.search.common.Serializer.SearchResultSetSerializer;
import static org.spin.tools.Util.guardNotNull;
import static org.spin.tools.Util.require;

import java.io.IOException;

import org.apache.log4j.Logger;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.lucene.LuceneSearchProviderFactory;
import org.eaglei.services.InstitutionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * 
 * @author Clint Gilbert
 * @author Ricardo DeLima
 * 
 * Jan 27, 2010
 *
 * Center for Biomedical Informatics (CBMI)
 *
 */
public final class DummyDataQueryAction extends SearchProviderQueryAction<SearchRequest, SearchResultSet>
{
    private static final Logger log = Logger.getLogger(DummyDataQueryAction.class);
    
    private static final boolean INFO = log.isInfoEnabled();
    
    public static enum PropNames
    {
        InstitutionURI, 
        InstitutionLabel;
        
        private static final String prefix = "Spin.Eagle-I.Props.DummyData.";
        
        public final String propKey = prefix + name();
    }
    
    public DummyDataQueryAction() throws IOException
    {
        this(getInstitutionLabel(), getInstitutionURI());
    }
    
    public DummyDataQueryAction(final String institutionLabel, final String institutionURI) throws IOException
    {
        super(SearchRequestSerializer, SearchResultSetSerializer, invokesQuery(createProviderForGeneratedData(institutionLabel, institutionURI)));
    }
    
    private static SearchProvider createProviderForGeneratedData(final String institutionLabel, final String institutionURI) throws IOException
    {
        final ApplicationContext context = new ClassPathXmlApplicationContext("services-config.xml", "jena-model-config.xml");
        
        final InstitutionRegistry institutionRegistry = context.getBean(InstitutionRegistry.class);
        
        final EIOntModel ontModel = context.getBean(EIOntModel.class);
        
        // TODO seems like LuceneSearchProviderFactory as well as this class should be
        //      located under the test source root... -Ted
        // I don't think so, we've needed to run this in "production" due to various repo issues in the past, and might again. -Clint
        return LuceneSearchProviderFactory.createProviderForGeneratedData(institutionRegistry, ontModel, makeDataGenParams(institutionRegistry, institutionLabel, institutionURI));
    }

    private static String getInstitutionURI()
    {
        return System.getProperty(PropNames.InstitutionURI.propKey);
    }
    
    private static String getInstitutionLabel()
    {
        return System.getProperty(PropNames.InstitutionLabel.propKey);
    }
    
    private static DataGenParams makeDataGenParams(final InstitutionRegistry institutionRegistry, final String institutionLabel, final String institutionURI)
    {
        guardNotNull(institutionRegistry);
        
        //load up the configured institution names
        final DataGenParams params;
        
        if(institutionLabel != null && institutionURI != null)
        {
            if(INFO)
            {
                log.info("Creating dummy data for '" + institutionLabel + "' (" + institutionURI + ")");
            }
            
            params = DataGenParams.createForOneInstitution(institutionURI, institutionLabel);
        }
        else
        {
            if(INFO)
            {
                log.info("Creating dummy data for one institution");
            }
            
            require(institutionRegistry != null);
            
            params = DataGenParams.createForOneInstitution(institutionRegistry.getInstitutions().get(0));
        }
        
        // ensure that the materialization is enabled
        
        params.setMaterializeHierarchy(true);
        
        return params;
    }
}
