/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.owlapiv3.OWL;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntailmentChecker
extends OWLAxiomVisitorAdapter
implements OWLAxiomVisitor {
    public static Logger log = Logger.getLogger(EntailmentChecker.class.getName());
    private IncrementalClassifier reasoner;
    private Boolean isEntailed;

    public EntailmentChecker(IncrementalClassifier reasoner) {
        this.reasoner = reasoner;
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) {
        for (OWLAxiom oWLAxiom : axioms) {
            if (this.isEntailed(oWLAxiom)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailed(OWLAxiom axiom) {
        this.isEntailed = null;
        axiom.accept((OWLAxiomVisitor)this);
        if (this.isEntailed == null) {
            throw new UnsupportedEntailmentTypeException(axiom);
        }
        return this.isEntailed;
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        OWLClassExpression subClass = axiom.getSubClass();
        OWLClassExpression superClass = axiom.getSuperClass();
        this.isEntailed = !this.reasoner.isClassified() || subClass.isAnonymous() || superClass.isAnonymous() ? Boolean.valueOf(this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom)) : Boolean.valueOf(this.reasoner.getTaxonomy().isSubNodeOf((OWLClass)subClass, (OWLClass)superClass).isTrue());
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.isEntailed = true;
        Iterator i = axiom.getClassExpressions().iterator();
        if (i.hasNext()) {
            OWLClassExpression first = (OWLClassExpression)i.next();
            while (i.hasNext() && this.isEntailed.booleanValue()) {
                OWLClassExpression next = (OWLClassExpression)i.next();
                if (!this.reasoner.isClassified() || first.isAnonymous() || next.isAnonymous()) {
                    this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)OWL.equivalentClasses(first, next));
                    continue;
                }
                this.isEntailed = this.reasoner.getTaxonomy().isEquivalent((OWLClass)first, (OWLClass)next).isTrue();
            }
        }
    }
}

