/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import com.clarkparsia.pellet.datatypes.DataRange;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionDataRange<T>
implements DataRange<T> {
    private final ArrayList<RestrictedDatatype<? extends T>> ranges;
    private final Set<? extends T> values;

    public UnionDataRange(Collection<RestrictedDatatype<? extends T>> ranges, Collection<? extends T> values) {
        this.ranges = new ArrayList<RestrictedDatatype<T>>(ranges);
        this.values = new HashSet<T>(values);
    }

    @Override
    public boolean contains(Object value) {
        if (this.values.contains(value)) {
            return true;
        }
        for (RestrictedDatatype<T> rd : this.ranges) {
            if (!rd.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if ((n -= this.values.size()) <= 0) {
            return true;
        }
        for (RestrictedDatatype<T> rd : this.ranges) {
            if (rd.containsAtLeast(n)) {
                return true;
            }
            n -= rd.size();
        }
        return n <= 0;
    }

    @Override
    public T getValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> valueIterator() {
        return new Iterator<T>(){
            final Iterator<? extends T> enumIt;
            final Iterator<RestrictedDatatype<? extends T>> rangeIt;
            Iterator<? extends T> valueIt;
            {
                this.enumIt = UnionDataRange.this.values.iterator();
                this.rangeIt = UnionDataRange.this.ranges.iterator();
                this.valueIt = null;
            }

            @Override
            public boolean hasNext() {
                if (this.enumIt.hasNext()) {
                    return true;
                }
                if (this.valueIt == null) {
                    if (this.rangeIt.hasNext()) {
                        this.valueIt = this.rangeIt.next().valueIterator();
                    } else {
                        return false;
                    }
                }
                while (!this.valueIt.hasNext()) {
                    if (this.rangeIt.hasNext()) {
                        this.valueIt = this.rangeIt.next().valueIterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.valueIt == null) {
                    return this.enumIt.next();
                }
                return this.valueIt.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

