/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.bool;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.EmptyIterator;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictedBooleanDatatype
implements RestrictedDatatype<Boolean> {
    private final Datatype<Boolean> dt;
    private final boolean permitFalse;
    private final boolean permitTrue;

    public RestrictedBooleanDatatype(Datatype<Boolean> dt) {
        this.dt = dt;
        this.permitTrue = true;
        this.permitFalse = true;
    }

    private RestrictedBooleanDatatype(RestrictedBooleanDatatype other, boolean permitTrue, boolean permitFalse) {
        this.dt = other.dt;
        this.permitFalse = permitFalse;
        this.permitTrue = permitTrue;
    }

    @Override
    public RestrictedDatatype<Boolean> applyConstrainingFacet(ATermAppl facet, Object value) throws InvalidConstrainingFacetException {
        throw new InvalidConstrainingFacetException(facet, value);
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            if (b.booleanValue()) {
                return this.permitTrue;
            }
            return this.permitFalse;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (n <= 0) {
            return true;
        }
        if (n == 1) {
            return this.permitTrue || this.permitFalse;
        }
        if (n == 2) {
            return this.permitTrue && this.permitFalse;
        }
        return false;
    }

    @Override
    public RestrictedDatatype<Boolean> exclude(Collection<?> values) {
        boolean permitTrue = this.permitTrue;
        boolean permitFalse = this.permitFalse;
        for (Object o : values) {
            if (!(o instanceof Boolean)) continue;
            Boolean b = (Boolean)o;
            if (b.booleanValue()) {
                permitTrue = false;
                continue;
            }
            permitFalse = false;
        }
        if (permitTrue == this.permitTrue && permitFalse == this.permitFalse) {
            return this;
        }
        return new RestrictedBooleanDatatype(this, permitTrue, permitFalse);
    }

    @Override
    public Datatype<? extends Boolean> getDatatype() {
        return this.dt;
    }

    @Override
    public Boolean getValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDatatype<Boolean> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedBooleanDatatype) {
            boolean permitFalse;
            RestrictedBooleanDatatype otherRBD = (RestrictedBooleanDatatype)other;
            boolean permitTrue = this.permitTrue && otherRBD.permitTrue;
            boolean bl = permitFalse = this.permitFalse && otherRBD.permitFalse;
            if (permitTrue == this.permitTrue && permitFalse == this.permitFalse) {
                return this;
            }
            if (permitTrue == otherRBD.permitTrue && permitFalse == otherRBD.permitFalse) {
                return otherRBD;
            }
            return new RestrictedBooleanDatatype(this, permitTrue, permitFalse);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return !this.permitTrue && !this.permitFalse;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public int size() {
        return (this.permitTrue ? 1 : 0) + (this.permitFalse ? 1 : 0);
    }

    @Override
    public RestrictedDatatype<Boolean> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedBooleanDatatype) {
            boolean permitFalse;
            RestrictedBooleanDatatype otherRBD = (RestrictedBooleanDatatype)other;
            boolean permitTrue = this.permitTrue || otherRBD.permitTrue;
            boolean bl = permitFalse = this.permitFalse || otherRBD.permitFalse;
            if (permitTrue == this.permitTrue && permitFalse == this.permitFalse) {
                return this;
            }
            if (permitTrue == otherRBD.permitTrue && permitFalse == otherRBD.permitFalse) {
                return otherRBD;
            }
            return new RestrictedBooleanDatatype(this, permitTrue, permitFalse);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<Boolean> valueIterator() {
        if (this.permitTrue) {
            if (this.permitFalse) {
                return Arrays.asList(Boolean.TRUE, Boolean.FALSE).iterator();
            }
            return Arrays.asList(Boolean.TRUE).iterator();
        }
        if (this.permitFalse) {
            return Arrays.asList(Boolean.FALSE).iterator();
        }
        return new EmptyIterator<Boolean>();
    }
}

