/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParserJavacc;
import com.google.gson.ParseException;
import com.google.gson.TokenMgrError;
import java.io.EOFException;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    public JsonElement parse(String json) throws JsonParseException {
        return this.parse(new StringReader(json));
    }

    public JsonElement parse(Reader json) throws JsonParseException {
        try {
            JsonParserJavacc parser = new JsonParserJavacc(json);
            JsonElement element = parser.parse();
            return element;
        }
        catch (TokenMgrError e2) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", e2);
        }
        catch (ParseException e3) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", e3);
        }
        catch (StackOverflowError e4) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", e4);
        }
        catch (OutOfMemoryError e5) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", e5);
        }
        catch (JsonParseException e6) {
            if (e6.getCause() instanceof EOFException) {
                return JsonNull.createJsonNull();
            }
            throw e6;
        }
    }
}

