/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.EagleIOntUtils;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.search.datagen.AbstractGenerator;
import org.eaglei.search.provider.SearchResult;

public class LuceneSearchProviderIndexer {
    private static final Log logger = LogFactory.getLog(LuceneSearchProviderIndexer.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String URI = "uri";
    public static final String PREF_TEXT = "pref_text";
    public static final String TEXT = "text";
    public static final String INDIRECT_TEXT = "indirect_text";
    public static final String RESOURCE_FLAG = "resourceFlag";
    public static final String INFERRED_TYPE = "inferredType";
    public static final String RELATED = "related";
    public static final String INSTITUTION_URI = "institution_uri";
    public static final String INSTITUTION_LABEL = "institution_label";
    public static final float LOW_BOOST = 0.5f;
    public static final float STANDARD_BOOST = 1.0f;
    public static final float MEDIUM_BOOST = 2.0f;
    public static final float HIGH_BOOST = 5.0f;
    private List<EIURI> prefLabelProperties = new ArrayList<EIURI>();
    private final EIOntModel eagleiOntModel;
    private final IndexWriter iwriter;

    public LuceneSearchProviderIndexer(EIOntModel eagleiOntModel, Analyzer analyzer, Directory directory) throws IOException {
        this.eagleiOntModel = eagleiOntModel;
        this.iwriter = new IndexWriter(directory, analyzer, IndexWriter.MaxFieldLength.LIMITED);
        this.retrieveOntologyMetadata();
    }

    private void retrieveOntologyMetadata() {
        List<Property> props = ((JenaEIOntModel)this.eagleiOntModel).getPrefLabelProperties();
        for (Property prop : props) {
            this.prefLabelProperties.add(EIURI.create(prop.getURI()));
        }
    }

    public IndexWriter getIndexWriter() {
        return this.iwriter;
    }

    public void commit() throws IOException {
        this.iwriter.optimize();
        this.iwriter.commit();
    }

    public void indexSearchResult(SearchResult result, boolean materializeTypes) throws IOException {
        EIURI uri = result.getEntity().getURI();
        PhraseQuery query2 = new PhraseQuery();
        query2.add(new Term(URI, uri.toString()));
        this.iwriter.deleteDocuments((Query)query2);
        if (result.getType().getURI().toString().equals("http://eagle-i.org/ont/repo/1.0/isDeleted")) {
            return;
        }
        Document doc = new Document();
        doc.add(new Field(URI, uri.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        EIEntity institutionEntity = result.getInstitution();
        doc.add(new Field(INSTITUTION_URI, institutionEntity.getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add(new Field(INSTITUTION_LABEL, institutionEntity.getLabel(), Field.Store.YES, Field.Index.ANALYZED));
        doc.add(new Field(TEXT, institutionEntity.getLabel(), Field.Store.YES, Field.Index.ANALYZED));
        EIEntity typeEntity = result.getType();
        EIClass typeClass = this.eagleiOntModel.getClass(typeEntity.getURI());
        if (typeClass == null) {
            logger.error("Resource " + result.getEntity() + " with type " + typeClass + " is not a valid eagle-i class");
            return;
        }
        doc.add(new Field(RESOURCE_FLAG, String.valueOf(typeClass.isEagleIResource()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add(new Field(RDF.type.getURI(), typeEntity.getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        for (EIClass type : AbstractGenerator.getTypes(this.eagleiOntModel, typeEntity.getURI(), materializeTypes)) {
            String typeURI = type.getEntity().getURI().toString();
            doc.add(new Field(INFERRED_TYPE, typeURI, Field.Store.YES, Field.Index.NOT_ANALYZED));
            String label = this.eagleiOntModel.getPreferredLabel(type.getEntity().getURI());
            if (label == null) continue;
            String fieldName = TEXT;
            float boost = 1.0f;
            if (typeURI.equals(typeEntity.getURI().toString())) {
                fieldName = PREF_TEXT;
                boost = 5.0f;
            }
            Field field = new Field(fieldName, label, Field.Store.YES, Field.Index.ANALYZED);
            field.setBoost(boost);
            doc.add(field);
        }
        for (EIURI propURI : result.getDataTypeProperties()) {
            if (this.shouldIgnore(typeClass, propURI)) {
                logger.info("Ignoring " + propURI);
                continue;
            }
            String fieldName = TEXT;
            float boost = 1.0f;
            if (this.prefLabelProperties.contains(propURI)) {
                fieldName = PREF_TEXT;
                boost = 5.0f;
            }
            Set<String> values = result.getDataTypeProperty(propURI);
            for (String value : values) {
                doc.add(new Field(propURI.toString(), value.toString(), Field.Store.YES, Field.Index.ANALYZED));
                Field field = new Field(fieldName, value, Field.Store.YES, Field.Index.ANALYZED);
                field.setBoost(boost);
                doc.add(field);
            }
        }
        for (EIURI propURI : result.getObjectProperties()) {
            if (this.shouldIgnore(typeClass, propURI)) {
                logger.info("Ignoring " + propURI);
                continue;
            }
            Set<EIURI> values = result.getObjectProperty(propURI);
            for (EIURI value : values) {
                doc.add(new Field(propURI.toString(), value.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add(new Field(RELATED, value.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
        }
        this.iwriter.addDocument(doc);
    }

    private boolean shouldIgnore(EIClass typeClass, EIURI uri) {
        return EagleIOntUtils.isPropertyInGroup(((JenaEIOntModel)this.eagleiOntModel).getOntModel(), "http://eagle-i.org/ont/app/1.0/PropertyGroup/adminData", uri.toString());
    }
}

