/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.floating;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.DiscreteInterval;
import com.clarkparsia.pellet.datatypes.EmptyRestrictedDatatype;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.types.floating.FloatingPointInterval;
import com.clarkparsia.pellet.datatypes.types.floating.FloatingPointType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictedFloatingPointDatatype<T extends Number>
implements RestrictedDatatype<T> {
    private static final Logger log = Logger.getLogger(RestrictedFloatingPointDatatype.class.getCanonicalName());
    private final boolean containsNaN;
    private final Datatype<? extends T> datatype;
    private final RestrictedDatatype<T> empty;
    private final List<FloatingPointInterval<T>> intervals;
    private final FloatingPointType<T> type;

    public RestrictedFloatingPointDatatype(Datatype<? extends T> datatype, FloatingPointType<T> type) {
        this.datatype = datatype;
        this.type = type;
        this.empty = new EmptyRestrictedDatatype<T>(datatype);
        this.intervals = Collections.singletonList(FloatingPointInterval.unconstrained(type));
        this.containsNaN = true;
    }

    private RestrictedFloatingPointDatatype(RestrictedFloatingPointDatatype<T> other, List<FloatingPointInterval<T>> intervals, boolean containsNaN) {
        this.datatype = other.datatype;
        this.type = other.type;
        this.empty = other.empty;
        this.intervals = Collections.unmodifiableList(intervals);
        this.containsNaN = containsNaN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RestrictedDatatype<T> applyConstrainingFacet(ATermAppl facet, Object value) {
        T upper;
        T lower;
        Facet f = Facet.Registry.get(facet);
        if (f == null) {
            String msg = String.format("Attempt to constrain datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), facet, value);
            log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (!this.type.isInstance(value)) {
            String msg = String.format("Attempt to constrain datatype (%s) using constraining facet ('%s') with an unsupported value ('%s')", this.getDatatype(), f, value);
            log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        T n = this.type.cast(value);
        if (!EnumSet.of(Facet.XSD.MAX_EXCLUSIVE, Facet.XSD.MAX_INCLUSIVE, Facet.XSD.MIN_EXCLUSIVE, Facet.XSD.MIN_INCLUSIVE).contains(f)) throw new IllegalStateException();
        if (this.type.isNaN(n)) {
            return this.empty;
        }
        if (Facet.XSD.MAX_EXCLUSIVE.equals(f)) {
            lower = this.type.getNegativeInfinity();
            if (n.equals(this.type.getNegativeInfinity())) {
                return this.empty;
            }
            upper = this.type.decrement(n);
        } else if (Facet.XSD.MAX_INCLUSIVE.equals(f)) {
            lower = this.type.getNegativeInfinity();
            upper = n;
        } else if (Facet.XSD.MIN_EXCLUSIVE.equals(f)) {
            if (n.equals(this.type.getPositiveInfinity())) {
                return this.empty;
            }
            lower = this.type.increment(n);
            upper = this.type.getPositiveInfinity();
        } else {
            if (!Facet.XSD.MIN_INCLUSIVE.equals(f)) throw new IllegalStateException();
            lower = n;
            upper = this.type.getPositiveInfinity();
        }
        FloatingPointInterval<T> restriction = new FloatingPointInterval<T>(this.type, lower, upper);
        ArrayList<FloatingPointInterval<T>> revisedIntervals = new ArrayList<FloatingPointInterval<T>>();
        boolean changes = this.containsNaN;
        for (FloatingPointInterval<T> i : this.intervals) {
            FloatingPointInterval<T> j = i.intersection(restriction);
            if (j != null) {
                revisedIntervals.add(j);
                if (i == j) continue;
                changes = true;
                continue;
            }
            changes = true;
        }
        if (!changes) return this;
        if (!revisedIntervals.isEmpty()) return new RestrictedFloatingPointDatatype<T>(this, revisedIntervals, false);
        return this.empty;
    }

    @Override
    public boolean contains(Object value) {
        if (this.type.isInstance(value)) {
            T n = this.type.cast(value);
            if (this.type.isNaN(n)) {
                return this.containsNaN;
            }
            for (FloatingPointInterval<T> i : this.intervals) {
                if (!i.contains(n)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (n <= 0) {
            return true;
        }
        Number sum = this.containsNaN ? 1 : 0;
        for (FloatingPointInterval<T> i : this.intervals) {
            if (OWLRealUtils.compare(sum = OWLRealUtils.integerSum(sum, i.size()), n) < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public RestrictedDatatype<T> exclude(Collection<?> values) {
        boolean changes = false;
        ArrayList<FloatingPointInterval<T>> revisedIntervals = new ArrayList<FloatingPointInterval<T>>(this.intervals);
        block0: for (Object o : values) {
            if (!this.type.isInstance(o)) continue;
            T n = this.type.cast(o);
            Iterator it = revisedIntervals.iterator();
            while (it.hasNext()) {
                DiscreteInterval greater;
                FloatingPointInterval i = (FloatingPointInterval)it.next();
                if (!i.contains(n)) continue;
                changes = true;
                it.remove();
                DiscreteInterval less = i.less((Number)n);
                if (less != null) {
                    revisedIntervals.add((FloatingPointInterval<T>)less);
                }
                if ((greater = i.greater((Number)n)) == null) continue block0;
                revisedIntervals.add((FloatingPointInterval<T>)greater);
                continue block0;
            }
        }
        if (changes) {
            if (revisedIntervals.isEmpty()) {
                return this.empty;
            }
            return new RestrictedFloatingPointDatatype<T>(this, revisedIntervals, this.containsNaN);
        }
        return this;
    }

    @Override
    public Datatype<? extends T> getDatatype() {
        return this.datatype;
    }

    @Override
    public T getValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDatatype<T> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedFloatingPointDatatype) {
            boolean toContainNaN;
            List<FloatingPointInterval<T>> intersectWith;
            if (!this.type.equals(((RestrictedFloatingPointDatatype)other).type)) {
                throw new IllegalArgumentException();
            }
            RestrictedFloatingPointDatatype otherRRD = (RestrictedFloatingPointDatatype)other;
            boolean changes = false;
            ArrayList<FloatingPointInterval<T>> revisedIntervals = new ArrayList<FloatingPointInterval<T>>();
            if (negated) {
                intersectWith = Collections.singletonList(FloatingPointInterval.unconstrained(this.type));
                for (FloatingPointInterval<T> i : otherRRD.intervals) {
                    ArrayList<FloatingPointInterval<T>> tmp = new ArrayList<FloatingPointInterval<T>>();
                    for (FloatingPointInterval<T> j : intersectWith) {
                        tmp.addAll(j.remove(i));
                    }
                    intersectWith = tmp;
                }
            } else {
                intersectWith = otherRRD.intervals;
            }
            for (FloatingPointInterval<T> i : this.intervals) {
                for (FloatingPointInterval<T> j : intersectWith) {
                    FloatingPointInterval<T> k = i.intersection(j);
                    if (k == i) continue;
                    changes = true;
                    if (k == null) continue;
                    revisedIntervals.add(k);
                }
            }
            if (this.containsNaN) {
                if (otherRRD.containsNaN) {
                    if (negated) {
                        changes = true;
                        toContainNaN = false;
                    } else {
                        toContainNaN = true;
                    }
                } else if (negated) {
                    toContainNaN = true;
                } else {
                    changes = true;
                    toContainNaN = false;
                }
            } else {
                toContainNaN = false;
            }
            if (changes) {
                if (revisedIntervals.isEmpty()) {
                    return this.empty;
                }
                return new RestrictedFloatingPointDatatype<T>(this, revisedIntervals, toContainNaN);
            }
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public int size() {
        long sum = this.containsNaN ? 1L : 0L;
        for (FloatingPointInterval<T> i : this.intervals) {
            if ((sum += i.size().longValue()) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public String toString() {
        return String.format("{%s,%s}", this.datatype, this.intervals);
    }

    @Override
    public RestrictedDatatype<T> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedFloatingPointDatatype) {
            if (!this.type.equals(((RestrictedFloatingPointDatatype)other).type)) {
                throw new IllegalArgumentException();
            }
            RestrictedFloatingPointDatatype otherRRD = (RestrictedFloatingPointDatatype)other;
            ArrayList<FloatingPointInterval<T>> revisedIntervals = new ArrayList<FloatingPointInterval<T>>(this.intervals);
            for (FloatingPointInterval<T> i : otherRRD.intervals) {
                ArrayList<FloatingPointInterval> unionWith = new ArrayList<FloatingPointInterval>();
                Iterator jt = revisedIntervals.iterator();
                while (jt.hasNext()) {
                    FloatingPointInterval j = (FloatingPointInterval)jt.next();
                    if (!i.canUnionWith(j)) continue;
                    jt.remove();
                    unionWith.add(j);
                }
                if (unionWith.isEmpty()) {
                    revisedIntervals.add(i);
                    continue;
                }
                HashSet<FloatingPointInterval> tmp = new HashSet<FloatingPointInterval>();
                for (FloatingPointInterval j : unionWith) {
                    tmp.addAll(i.union(j));
                }
                revisedIntervals.addAll(tmp);
            }
            boolean toContainNaN = this.containsNaN || otherRRD.containsNaN;
            return new RestrictedFloatingPointDatatype<T>(this, revisedIntervals, toContainNaN);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<T> valueIterator() {
        return new Iterator<T>(){
            final Iterator<FloatingPointInterval<T>> iit;
            Iterator<T> nit;
            {
                this.iit = RestrictedFloatingPointDatatype.this.intervals.iterator();
                this.nit = null;
            }

            @Override
            public boolean hasNext() {
                while (this.nit == null || !this.nit.hasNext()) {
                    if (this.iit.hasNext()) {
                        this.nit = this.iit.next().valueIterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (Number)this.nit.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

